---
title: Doctype Declaration
localeTitle: Объявление Doctype
---
## Объявление Doctype

Объявление типа документа HTML, также известное как `DOCTYPE` , является первой строкой кода, требуемой в каждом документе HTML или XHTML. Объявление `DOCTYPE` - это инструкция для веб-браузера о том, какая версия HTML-страницы написана. Это гарантирует, что веб-страница анализируется одинаково различными браузерами.

В HTML 4.01 декларация `DOCTYPE` относится к определению типа документа (DTD). DTD определяет структуру и юридические элементы XML-документа. Поскольку HTML 4.01 был основан на стандартном обобщенном языке разметки (SGML), необходимо было обратиться к DTD в объявлении `DOCTYPE` .

Кроме того, doctypes для HTML 4.01 требовал объявления либо `strict` , `transitional` , либо `frameset` DTD `frameset` , каждый с другим вариантом использования, как описано ниже.

*   **Strict DTD** : используется для веб-страниц, которые _исключают_ атрибуты и элементы, которые W3C ожидает поэтапного отказа от поддержки CSS
*   **Transitional DTD** : используется для веб-страниц, которые _включают_ атрибуты и элементы, которые W3C ожидает поэтапного отказа от поддержки CSS
*   **Frameset DTD** : используется для веб-страниц с фреймами

Напротив, декларация HTML5 `DOCTYPE` намного проще: она больше не требует ссылки на DTD, поскольку она больше не основана на SGML. См. Приведенные ниже примеры для сравнения между HTML 4.01 и HTML5 `DOCTYPE` .

### Примеры

Синтаксис Doctype для HTML5 и выше:

```html

<!DOCTYPE html> 
```

Синтаксис Doctype для строгого HTML 4.01:

```html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> 
```

Синтаксис Doctype для переходного HTML 4.01:

```html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"> 
```

Синтаксис Doctype для фреймов HTML 4.01:

```html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd"> 
```

## история

В течение образовательных лет HTML веб-стандарты еще не согласованы. Поставщики браузеров будут создавать новые функции любым способом. Конкурирующих браузеров было мало. В результате веб-разработчикам пришлось выбирать браузер для разработки своих сайтов. Это означало, что сайты не будут хорошо отображаться в неподдерживаемых браузерах. Эта ситуация не может продолжаться.

W3C (консорциум World Wide Web) написал набор веб-стандартов для обработки этой ситуации. Все разработчики браузеров и веб-разработчики должны придерживаться этих стандартов. Это гарантирует, что веб-сайты будут хорошо отображаться в браузерах. Изменения, требуемые стандартами, сильно отличались от некоторых существующих практик. Присоединение к ним приведет к нарушению существующих веб-сайтов, не соответствующих стандартам.

Чтобы справиться с этой проблемой, производители начали программировать режимы рендеринга в своих браузерах. Веб-разработчикам необходимо добавить объявление doctype в начало документа HTML. Объявление doctype сообщит браузеру, какой режим рендеринга использовать для этого документа. В браузерах обычно доступны три режима рендеринга. **Режим Full Standards** предоставляет страницы в соответствии с веб-стандартами W3C. **Режим Quirks** делает страницы нестандартным образом. **Почти стандартный режим** близок к полному стандарту, но имеет поддержку небольшого количества причуд.

В современную эпоху HTML5 веб-стандарты полностью реализованы во всех основных браузерах. Веб-сайты обычно разрабатываются стандартно. Из-за этого объявление типа HTML5 существует только для того, чтобы сообщить браузеру о том, чтобы сделать документ в режиме стандартных стандартов.

## использование

Декларация Doctype должна быть самой первой строкой кода в HTML-документе, кроме комментариев, которые могут быть представлены до нее, если это необходимо. Для современных документов HTML5 декларация doctype должна быть следующей:

`<!DOCTYPE html>`

#### Дополнительная информация:

Хотя больше не используются в общем случае, существует несколько других типов объявлений типа doctype из предыдущих версий HTML. Существуют также конкретные версии для XML-документов. Чтобы узнать больше об этом и посмотреть примеры кода для каждого, посмотрите [статью Википедии](https://en.wikipedia.org/wiki/Document_type_declaration) .

[Примечание от W3](https://www.w3.org/QA/Tips/Doctype)

[Вход в Глоссарий MDN](https://developer.mozilla.org/en-US/docs/Glossary/Doctype)

[W3Schools](https://www.w3schools.com/tags/tag_doctype.asp)

[Быстрое объяснение «Режим Quirks» и «Режим стандартов»](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode)