---
title: A Tag
localeTitle: День
---
## Тег

Тег `<a>` или элемент _привязки_ создает гиперссылку на другую страницу или файл. Чтобы ссылаться на другую страницу или файл, тег `<a>` должен также содержать атрибут `href` , который указывает назначение ссылки.

Ссылка между открывающим и закрывающим тегами `<a>` становится ссылкой.

По умолчанию в текущем окне браузера отображается связанная страница, если не указана другая цель.

#### Пример:

```html

  <a href= "https://guide.freecodecamp.org/">freeCodeCamp</a> 
```

Изображение также можно превратить в ссылку, заключая `<img>` тег `<a>` .

#### Пример:

```html

  <a href= "https://guide.freecodecamp.org/"><img src="logo.svg"></a> 
```

Также возможно определить цель тега `<a>` . Это делается с использованием `target` атрибута. Атрибут `target` имеет следующие значения: `_blank|_self|_parent|_top|framename` .

`_blank` : открывает ссылку на новой вкладке или в новом окне в зависимости от предпочтений пользователя. `_self` : открывает ссылку в том же фрейме (поведение по умолчанию). `_parent` : открывает ссылку в родительском фрейме, например, когда пользователь нажимает ссылку в iframe. `_top` : открывает ссылку во всей полноте окна. `framename` : Открывает ссылку в указанном фрейме.

#### Пример:

```html

  <a href= "https://guide.freecodecamp.org/" target="_blank">freeCodeCamp</a> 
```

[freeCodeCamp](https://guide.freecodecamp.org/) Эта ссылка создается так же, как предлагает пример кода. Нажмите, чтобы посмотреть, как это работает.

Также тег <a> может содержать атрибут rel="nofollow", который будет запрещать поисковым роботам переходить по ссылке. Часто такой атрибут используется поисковой оптимизации сайтов.

#### Пример:

<a href="https://guide.freecodecamp.org/" rel="nofollow">freeCodeCamp</a>
  

#### Дополнительная информация:

*   [Элемент HTML <a>: MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a)
*   [Тег: w3schools](https://www.w3schools.com/tags/tag_a.asp)
*   [Тег: htmlreference.io](http://htmlreference.io/element/a/)
