---
title: Blockquote Tag
localeTitle: Тег Blockquote
---
## Тег Blockquote

### Цель

Элемент HTML `<blockquote>` выделяет цитату из окружающего содержимого. Это позволяет читателю ясно видеть цитату как материал, приписываемый ее оригинальному автору.

### использование

Подобно тому, как теги «H» посылают сигнал читателю, что информация важна, блок-код предупреждает читателя, что информация, которую они читают, принадлежит внешнему источнику. Тег `<blockquote>` может включать URL-адрес источника цитаты, который может быть задан с использованием атрибута cite, тогда как текстовое представление источника может быть задано с помощью элемента `<cite>` .

### пример

```html

<blockquote cite="https://www.cnet.com/news/tim-cook-maintains-steve-jobs-beatles-business-model/"> 
 “My model for business is The Beatles. They were four guys who kept each other's kind of negative tendencies in check. 
 They balanced each other and the total was greater than the sum of the parts. 
 That's how I see business: great things in business are never done by one person, they're done by a team of people.” 
 </blockquote> 
 <cite>Steve Jobs</cite> 
```

#### Дополнительная информация:

[blockquote MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blockquote)