---
title: Button Tag
localeTitle: Значок кнопки
---
## Значок кнопки

Тег `<button>` указывает кнопку clickable в документе HTML. Между тегами `<button>` вы можете размещать контент, например текст или изображения. Это отличается от кнопки, созданной с помощью `<input>` , который принимает текст только как контент.

**Синтаксис:**

`<button type="submit">Click Here!</button>`

**Atributes:**

Ниже приведен соответствующий атрибут, поддерживаемый HTML 4:

| **Атрибуты** | **Значение** | **Что он делает** | | --- | --- | --- | | отключен | отключен | Отключает кнопку | | имя | имя | Указывает имя кнопки. Имя предназначено для ссылки на кнопку в HTML-форме, JS и т. Д. | | тип | кнопку или сбросить или отправить | Устанавливает тип кнопки. Кнопка с типом `button` - это простая кнопка для клика, с типом `submit` она отправляет данные формы, а с типом `reset` она сбрасывает данные формы. | | стоимость | текст | Устанавливает начальное значение для кнопки. Это значение отправляется вместе с данными формы. |

HTML 5 поддерживает следующие дополнительные атрибуты:

| **Атрибуты** | **Значение** | **Что он делает** | | --- | --- | --- | | автофокус | автофокус | Если кнопка автоматически получает фокус при загрузке страницы. Например, см. Google. Когда страница загружается полностью, текстовое поле автоматически фокусируется. | | форма | form\_id | Указывает одну или несколько форм, которым принадлежит кнопка. | | формование | URL | Указывает, куда отправлять данные формы после нажатия кнопки типа `submit` . | | formmethod | получить или отправить | Указывает, как отправить данные формы. Только для кнопки типа `submit` . | | formtarget | `_blank` или `_self` или `_parent` или `_top` или framename | Определяет место, где результат должен отображаться после отправки данных формы. |

**Пример:**

```html

<html> 
  <head> 
    <title>Button Tag example</title> 
  </head> 
  <body> 
    <form> 
      First name:<br> 
      <input type="text" name="firstname" value="Free"> 
      <br> 
      Last name:<br> 
      <input type="text" name="lastname" value="CodeCamp"> 
      <br><br> 
      <input type="submit" value="Submit" formtarget="_self"> 
    </form> 
  </body> 
 </html> 
```

Все основные браузеры поддерживают `<button>` . Тег `<button>` также поддерживает атрибуты событий в HTML. **Примечание.** Различные браузеры могут отправлять разные значения, если вы используете элемент `<button>` . Рекомендуется указывать значение кнопки или использовать `<input>` для создания кнопки в форме HTML.

**Другие источники:**

*   Другие атрибуты:

| **Атрибуты** | **Ссылка** | | --- | --- | | formenctype | https://www.w3schools.com/TAgs/att _button_ formenctype.asp | | формовалидат | https://www.w3schools.com/TAgs/att _button_ formnovalidate.asp |

*   `<input>` : https://www.w3schools.com/TAgs/tag\_input.asp
*   Атрибуты событий: https://www.w3schools.com/TAgs/ref\_eventattributes.asp
*   `formtarget` атрибутов `formtarget` : https://www.w3schools.com/TAgs/att _button_ formarget.asp
*   Форма HTML: