---
title: Doctype Tag
localeTitle: Тег Doctype
---
## Тег Doctype

HTML-код всегда сопровождается «шаблоном» тегов. Самый первый тег, найденный в любом файле HTML, должен быть объявлением Doctype. Html5 doctype `<!DOCTYPE html>` - это обязательная преамбула, используемая для информирования браузера о том, какой [режим рендеринга](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode) использовать (HTML5 и XHTML). Обязательно поместите doctype в самый верх документа.

```html

<!DOCTYPE html> 
 <html> 
    <head> 
        <meta charset=UTF-8> 
        <title>Document Title</title> 
    </head> 
    <body> 
        <p>Document content.</p> 
    </body> 
 </html> 
```

#### Дополнительная информация:

*   [Doctype: MDN](https://developer.mozilla.org/en-US/docs/Glossary/Doctype)
*   [Введение в HTML5: MDN](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/HTML5/Introduction_to_HTML5)
*   [Режим Quirks и режим стандартов: MDN](https://developer.mozilla.org/en-US/docs/Quirks_Mode_and_Standards_Mode)