---
title: Elements
localeTitle: элементы
---
# Элементы HTML

Элементы являются строительными блоками HTML, которые описывают структуру и содержимое веб-страницы. Они являются частью «Разметки» языка разметки гипертекста (HTML).

Синтаксис HTML использует угловые скобки («<» и «>») для хранения имени элемента HTML. Элементы обычно имеют открывающий тег и закрывающий тег и предоставляют информацию о содержании, которое они содержат. Разница между ними заключается в том, что закрывающий тег имеет косую черту.

Вот пример использования [элемента p](#) ( `<p>` ), чтобы сообщить браузеру, что группа текста является абзацем:

```html

<p>This is a paragraph.</p> 
```

Теги открытия и закрытия должны совпадать, иначе браузер может отображать содержимое неожиданным образом.

![XKCD комикс, показывающий текст «Q: Как вы раздражаете разработчика?» окруженный меткой открытия div и тегом закрытия закрытия](http://imgs.xkcd.com/comics/tags.png)

## Самозакрывающиеся элементы

Некоторые элементы HTML являются самозакрывающимися, что означает, что у них нет отдельного закрывающего тега. Самозакрывающиеся элементы обычно вставляют что-то в ваш документ.

Примером может служить [элемент br](#) ( `<br>` ), который вставляет текст в текст. Раньше самозакрывающиеся теги имели прямую косую черту ( `<br />` ), однако спецификация HTML5 больше не требует этого.

## Функциональность HTML-элемента

Существует много доступных элементов HTML. Вот список некоторых функций, которые они выполняют:

*   предоставить информацию о самой веб-странице (метаданные)
*   структурировать содержимое страницы на разделы
*   вставлять изображения, видео, аудиоклипы или другие мультимедиа
*   создавать списки, таблицы и формы
*   предоставить больше информации о определенном текстовом содержимом
*   ссылка на таблицы стилей, в которых есть правила о том, как браузер должен отображать страницу
*   добавьте скрипты, чтобы сделать страницу более интерактивной и динамичной

## Вложения HTML-элементов

Вы можете вставлять элементы внутри других элементов в HTML-документ. Это помогает определить структуру страницы. Просто убедитесь, что теги ближе к самому внутреннему элементу.

Верный: `<p>This is a paragraph that contains a <span>span element.</span></p>`

Неправильно: `<p>This is a paragraph that contains a <span>span element.</p></span>`

## Блочные и встроенные элементы

Элементы входят в две общие категории, известные как блочные и встроенные. Элементы уровня блока автоматически начинаются с новой строки, а встроенные элементы - в окружающем контенте.

Элементы, которые помогают структурировать страницу на разделы, такие как панель навигации, заголовки и абзацы, обычно являются элементами уровня блока. Элементы, которые вставляют или предоставляют больше информации о контенте, обычно являются встроенными, такими как [ссылки](#) или [изображения](#) .

## Элемент HTML

Существует элемент `<html>` который используется для размещения другой разметки для HTML-документа. Он также известен как «корневой» элемент, поскольку он является родителем других элементов HTML и содержимого страницы.

Вот пример страницы с [элементом головы, элементом](#the-head-element) [тела](#the-body-element) и одним [абзацем](#the-p-element) :

```html

<!DOCTYPE html> 
 <html> 
  <head> 
  </head> 
  <body> 
    <p>I'm a paragraph</p> 
  </body> 
 </html> 
```

## Элемент HEAD

Это контейнер для обработки информации и метаданных для HTML-документа.

```html

<head> 
  <meta charset="utf-8"> 
 </head> 
```

## Элемент BODY

Это контейнер для отображаемого содержимого HTML-документа.

```html

<body>...</body> 
```

## Элемент P

Создает абзац, возможно, самый распространенный элемент уровня блока.

```html

<p>...</p> 
```

## Элемент A (Link)

Создает гиперссылку для прямых посетителей на другую страницу или ресурс.

```html

<a href="#">...</a> 
```

## Другие источники

*   [HTML-абзацы](#)
*   [HTML br](#)
*   [Ссылки на HTML](#)
*   [Изображения HTML](#)
*   [Заголовок HTML](#)
*   [Тело HTML](#)
*   [HTML DOCTYPE](#)