---
title: HTML Entities
localeTitle: HTML-объекты
---
# HTML-объекты

## обзор

### Что такое HTML-объекты?

Объекты HTML - это символы, которые используются для замены зарезервированных символов в HTML или для символов, которые не отображаются на клавиатуре. Некоторые символы зарезервированы в HTML. Если вы используете в тексте меньше знаков (<) или больше (>), браузер может смешивать их с тегами.

### Для чего они используются?

Как уже упоминалось, элементы HTML используются для замены зарезервированных символов, зарезервированных HTML.

### Как вы их используете?

Объект-символ выглядит примерно так:

```html

<!-- format &[entity_name]; --> 
 <!-- example for a less-than sign (<) --> 
 &lt; 
```

Или

```html

<!-- &#[entity_number]; --> 
 <!-- example for a less-than sign (<) --> 
 &#60; 
```

## Справочное руководство

Это ни в коем случае не исчерпывающий список, но приведенные ниже ссылки смогут предоставить вам больше объектов, если приведенные ниже не работают для ваших нужд. Счастливое кодирование: bowtie:

| Персонаж | Имя объекта | Номер объекта | Описание | | ------- | ----------- | ----------- | ------- | | | | `&#32;` | Космос | | ! | | `&#33;` | Восклицательный знак | | "| | `&#34;` | Котировочная марка | | # | | `&#35;` | Номер знак | | $ | | `&#36;` | Знак доллара | | ¢ | `&cent;` | `&#162;` | Знак Cent | | € | `&euro;` | `&#8364;` | Знак евро | | £ | `&pound;` | `&#163;` | Знак GBP | | ¥ | `&yen;` | `&#165;` | Знак йены | | % | | `&#37;` | Знак процента | | & | `&amp;` | `&#38;` | Амперсанд | | '| | `&#39;` | Апостроф | | (| | `&#40;` | Открытие / Левая скобка | | ) | | `&#41;` | Закрытие / Прямая скобка | | \* | | `&#42;` | Asterisk | | + | | `&#43;` | Плюс знак | | , | | `&#44;` | Comma | | - | | `&#45;` | Hyphen | | , | | `&#46;` | Период | | / | | `&#47;` | Слэш | | © | `&copy;` | `&#169;` | Авторское право | | ® | `&reg;` | `&#174;` | Зарегистрированный товарный знак | | "| `&quot;` | `&#34;` | двойная кавычка | | `>` | `&gt;` | `&#62;` | Больше, чем знак | | `<` | `&lt;` | `&#60;` | Меньше, чем знак | | `•` | `&bull;` | `&#8226` | Точка пули |

#### Дополнительная информация:

Существует множество HTML-ссылок на ссылки; некоторые примеры:

*   [Таблица сущностей - W3](https://dev.w3.org/html5/html-author/charref)
*   [W3 Школы](https://www.w3schools.com/html/html_entities.asp)
*   [Freeformatter](https://www.freeformatter.com/html-entities.html)