---
title: HTML5 Semantic Elements
localeTitle: HTML5 Семантические элементы
---
## HTML5 Семантические элементы

Семантические элементы HTML четко описывают его значение в человеческом и машиносчитываемом виде. Элементы, такие как `<header>` , `<footer>` и `<article>` , считаются семантическими, потому что они точно описывают цель элемента и тип содержимого, который внутри них.

### Краткая история

HTML был первоначально создан как язык разметки для описания документов в начале интернета. По мере того, как Интернет рос и был принят больше людей, его потребности изменились. Когда интернет был первоначально предназначен для обмена научными документами, теперь люди хотели поделиться и другими вещами. Очень быстро люди начали хотеть сделать Интернет более приятным. Поскольку веб-сервер изначально не был спроектирован для разработки, программисты использовали разные хаки, чтобы все было по-разному. Вместо использования `<table></table>` для описания информации с использованием таблицы программисты использовали бы их для размещения других элементов на странице. По мере прогрессирования использования визуально разработанных макетов программисты начали использовать общий «не семантический» тег, например `<div>` . Они часто давали этим элементам атрибут `class` или `id` для описания своей цели. Например, вместо `<header>` это часто записывалось как `<div class="header">` . Поскольку HTML5 по-прежнему относительно нов, это использование не семантических элементов по-прежнему очень распространено на веб-сайтах сегодня.

#### Список новых семантических элементов

Семантические элементы, добавленные в HTML5:

*   `<article>`
*   `<aside>`
*   `<details>`
*   `<figcaption>`
*   `<figure>`
*   `<footer>`
*   `<header>`
*   `<main>`
*   `<mark>`
*   `<nav>`
*   `<section>`
*   `<summary>`
*   `<time>`

Элементы, такие как `<header>` , `<nav>` , `<section>` , `<article>` , `<aside>` и `<footer>` действуют более или менее как элементы `<div>` . Они группируют другие элементы вместе в разделы страниц. Однако, если `<div>` может содержать любой тип информации, легко определить, какая информация будет отображаться в семантической области `<header>` .

**Пример размещения семантического элемента w3schools**

![Семантические элементы, составляющие страницу w3schools](https://www.w3schools.com/html/img_sem_elements.gif)

### Преимущества семантических элементов

Чтобы взглянуть на преимущества семантических элементов, вот два фрагмента кода HTML. Этот первый блок кода использует семантические элементы:
```
<header></header> 
 <section> 
    <article> 
        <figure> 
            <img> 
            <figcaption></figcaption> 
        </figure> 
    </article> 
 </section> 
 <footer></footer> 
```

Хотя этот второй блок кода использует не семантические элементы:
```
<div id="header"></div> 
 <div class="section"> 
    <div class="article"> 
        <div class="figure"> 
            <img> 
            <div class="figcaption"></div> 
        </div> 
    </div> 
 </div> 
 <div id="footer"></div> 
```

Во-первых, его гораздо **легче читать** . Это, вероятно, первое, что вы заметите при просмотре первого блока кода с использованием семантических элементов. Это небольшой пример, но в качестве программиста вы можете читать сотни или тысячи строк кода. Чем проще читать и понимать этот код, тем легче он делает вашу работу.

Он имеет **большую доступность** . Вы не единственный, который легче воспринимает семантические элементы. Поисковые системы и вспомогательные технологии (например, программы для чтения с экрана для пользователей с ухудшением зрения) также могут лучше понимать контекст и содержание вашего веб-сайта, что означает лучший опыт для ваших пользователей.

В целом, семантические элементы также приводят к более **согласованному коду** . При создании заголовка с использованием не семантических элементов разные программисты могут записать это как `<div class="header">` , `<div id="header">` , `<div class="head">` или просто `<div>` . Существует так много способов создать элемент заголовка, и все они зависят от личных предпочтений программиста. Создавая стандартный семантический элемент, он упрощает работу для всех.

С октября 2014 года HTML4 был повышен до HTML5, а также некоторые новые «семантические» элементы. По сей день некоторые из нас все еще могут быть смущены тем, почему так много разных элементов, которые, похоже, не показывают каких-либо серьезных изменений.

#### `&#60;section&#62;` и `&#60;article&#62;`

«В чем разница?», Спросите вы. Оба эти элемента используются для секционирования содержимого, и да, они могут определенно использоваться взаимозаменяемо. Это вопрос ситуации. HTML4 предлагает только один тип элементов контейнера, который является `&#60;div&#62;` , Хотя это все еще используется в HTML5, HTML5 предоставил нам `&#60;section&#62;` и `&#60;article&#62;` чтобы заменить `&#60;div&#62;` ,

`&#60;section&#62;` и `&#60;article&#62;` элементы концептуально похожи и взаимозаменяемы. Чтобы решить, какой из них вы должны выбрать, обратите внимание на следующее:

1.  Статья предназначена для самостоятельного распределения или повторного использования.
2.  Раздел представляет собой тематическую группировку контента.

```html

<section> 
  <p>Top Stories</p> 
  <section> 
    <p>News</p> 
    <article>Story 1</article> 
    <article>Story 2</article> 
    <article>Story 3</article> 
  </section> 
  <section> 
    <p>Sport</p> 
    <article>Story 1</article> 
    <article>Story 2</article> 
    <article>Story 3</article> 
  </section> 
 </section> 
```

#### `&#60;header&#62;` и `&#60;hgroup&#62;`

`&#60;header&#62;` элемент обычно находится в верхней части документа, раздела или статьи и обычно содержит основной заголовок и некоторые средства навигации и поиска.

```html

<header> 
  <h1>Company A</h1> 
  <ul> 
    <li><a href="/home">Home</a></li> 
    <li><a href="/about">About</a></li> 
    <li><a href="/contact">Contact us</a></li> 
  </ul> 
  <form target="/search"> 
    <input name="q" type="search" /> 
    <input type="submit" /> 
  </form> 
 </header> 
```

`&#60;hgroup&#62;` элемент должен использоваться там, где вам нужен основной заголовок с одной или несколькими подзаголовками.

```html

<hgroup> 
  <h1>Heading 1</h1> 
  <h2>Subheading 1</h2> 
  <h2>Subheading 2</h2> 
 </hgroup> 
```

ПОМНИТЕ, что `&#60;header&#62;` элемент может содержать любой контент, но `&#60;hgroup&#62;` элемент может содержать только другие заголовки, то есть `&#60;h1&#62;` to `&#60;h6&#62;` и включая `&#60;hgroup&#62;` ,

#### `&#60;aside&#62;`

`&#60;aside&#62;` элемент предназначен для контента, который не является частью потока текста, в котором он появляется, однако все еще связан каким-то образом. Это от `&#60;aside&#62;` как боковая панель вашего основного контента.

```html

<aside> 
  <p>This is a sidebar, for example a terminology definition or a short background to a historical figure.</p> 
 </aside> 
```

Перед HTML5 наши меню были созданы с помощью `&#60;ul&#62;` 's и `&#60;li&#62;` «S. Теперь, вместе с ними, мы можем отделить наши пункты меню с помощью `&#60;nav&#62;` , для навигации между вашими страницами. У вас может быть любое число `&#60;nav&#62;` элементы на странице, например, общие для глобальной навигации по вершине (в `&#60;header&#62;` ) и локальной навигации на боковой панели (в элементе `&#60;aside&#62;` ).

```html

<nav> 
  <ul> 
    <li><a href="/home">Home</a></li> 
    <li><a href="/about">About</a></li> 
    <li><a href="/contact">Contact us</a></li> 
  </ul> 
 </nav> 
```

#### `&#60;footer&#62;`

Если есть `&#60;header&#62;` должен быть `&#60;footer&#62;` , A `&#60;footer&#62;` обычно находится в нижней части документа, раздела или статьи. Как `&#60;header&#62;` содержание, как правило, является метаинформацией, такой как данные автора, юридическая информация и / или ссылки на соответствующую информацию. Также справедливо включить `&#60;section&#62;` элементы в нижнем колонтитуле.

```html

<footer>&copy;Company A</footer> 
```

#### `&#60;small&#62;`

`&#60;small&#62;` элемент часто появляется в `&#60;footer&#62;` или `&#60;aside&#62;` элемент, который обычно содержит информацию об авторских правах или юридические заявления об отказе от ответственности и другую такую ​​мелкую печать. Однако это не означает, что текст меньше. Он просто описывает его содержание, не предписывая презентацию.

```html

<footer><small>&copy;Company A</small> Date</footer> 
```

#### `&#60;time&#62;`

`&#60;time&#62;` элемент позволяет однозначно устанавливать дату ISO 8601 на читаемую человеком версию этой даты.

```html

<time datetime="2017-10-31T11:21:00+02:00">Tuesday, 31 October 2017</time> 
```

Зачем беспокоиться о `&#60;time&#62;` ? В то время как люди могут читать время, которое может однозначно рассортироваться через контекст, компьютеры могут считывать дату ISO 8601 и видеть дату, время и часовой пояс.

#### `&#60;figure&#62;` и `&#60;figcaption&#62;`

`&#60;figure&#62;` для обертывания содержимого изображения вокруг него и `&#60;figcaption&#62;` это заголовок вашего изображения.

```html

<figure> 
  <img src="https://en.wikipedia.org/wiki/File:Shadow_of_Mordor_cover_art.jpg" alt="Shadow of Mordor" /> 
  <figcaption>Cover art for Middle-earth: Shadow of Mordor</figcaption> 
 </figure> 
```

### Подробнее о новых элементах HTML5 ...

*   [w3schools](https://www.w3schools.com/html/html5_semantic_elements.asp) предоставляет простые и четкие описания многих элементов новостей и как / где они должны использоваться.
*   [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element) также обеспечивает отличную ссылку для всех элементов HTML и углубляется в каждый.