---
title: Iframes
localeTitle: Iframes
---
## Iframes

Элемент HTML `<iframe>` представляет встроенный фрейм, который позволяет включать независимый HTML-документ в текущий HTML-документ. `<iframe>` обычно используется для встраивания сторонних носителей, собственных медиафайлов, виджетов, фрагментов кода или вложений сторонних апплетов, таких как формы оплаты.

### Атрибуты

Ниже перечислены некоторые атрибуты `<iframe>` :

| Атрибут | Описание | | --- | --- | | `allowfullscreen` | Установите значение true, чтобы позволить кадру быть помещенным в полноэкранный режим | | `frameborder` | Указывает браузеру нарисовать рамку вокруг кадра (по умолчанию установлено 1) | | `height` | Высота кадра в пикселях CSS | | `name` | Имя кадра | | `src` | URL-адрес веб-страницы для вставки | | `width` | Ширина кадра в пикселях CSS |

### Примеры

Внедрение видео YouTube с помощью `<iframe>` :

```html

<iframe width="560" height="315" src="https://www.youtube.com/embed/v8kFT4I31es" 
 frameborder="0" allowfullscreen></iframe> 
```

Внедрение Google Maps с помощью `<iframe>` :

```html

<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d774386.2436462595!2d-74.53874786161381!3d40.69718109704434!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c24fa5d33f083b%3A0xc80b8f06e177fe62!2sNew+York%2C+NY%2C+USA!5e0!3m2!1sen!2sau!4v1508405930424" 
 width="600" height="450" frameborder="0" style="border:0" allowfullscreen></iframe> 
```

### Альтернативный текст

Содержимое между открывающим и закрывающим тегами `<iframe>` используется как альтернативный текст, отображаемый, если браузер просмотра не поддерживает iframe.

```html

<iframe width="560" height="315" src="https://www.youtube.com/embed/v8kFT4I31es" frameborder="0"> 
  <p>Your browser does not support iframes.</p> 
 </iframe> 
```

### Ориентация на iframe в ссылке

Любая ссылка `<a>` может быть нацелена на содержимое элемента `<iframe>` . Вместо того, чтобы перенаправлять окно браузера на связанную веб-страницу, он перенаправляет `<iframe>` . Чтобы это работало, атрибут `target` элемента `<a>` должен соответствовать атрибуту `name` `<iframe>` .

```html

<iframe width="560" height="315" src="about:blank" frameborder="0" name="iframe-redir"></iframe> 
 
 <p><a href="https://www.youtube.com/embed/v8kFT4I31es" target="iframe-redir">Redirect the Iframe</a></p> 
```

В этом примере сначала будет отображаться пустой `<iframe>` , но когда вы нажмете ссылку выше, она перенаправит `<iframe>` чтобы показать видео YouTube.

### Javascript и iframes

Документы, встроенные в `<iframe>` могут запускать JavaScript в своем собственном контексте (без влияния на родительскую веб-страницу) как обычно.

Любое взаимодействие скриптов между родительской веб-страницей и содержимым встроенного `<iframe>` подчиняется политике одного и того же происхождения. Это означает, что если вы загружаете содержимое `<iframe>` из другого домена, браузер блокирует любую попытку доступа к этому контенту с помощью JavaScript.

### Дополнительная информация:

См. [Веб-документы MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe) .