---
title: HTML
localeTitle: HTML
---
# HTML

Язык разметки гипертекста (HTML) - это язык разметки, используемый для создания онлайновых документов и сегодня является основой большинства веб-сайтов. Языки разметки, такие как HTML, позволяют нам: 1) создавать ссылки на другие документы, 2) структурировать контент в нашем документе и 3) приписывать контекст и смысл содержанию нашего документа.

HTML-документ имеет два аспекта. Он содержит структурированную информацию (Markup) и текстовые ссылки (HyperText) для других документов. Мы структурируем наши страницы с помощью [HTML-элементов](#) . Они являются конструкциями языка, предоставляющего [структуру](#) и [значение](#) в нашем документе для браузера и элемент ссылки на другие документы через Интернет.

Интернет был первоначально создан для хранения и представления статических (неизменных) документов. Описанные выше аспекты HTML были прекрасно видны в этих документах, в которых не было всего дизайна и стиля. Они представили структурированную информацию, содержащую ссылки на другие документы.

HTML5 - это последняя версия или спецификация HTML. Консорциум World Wide Web (W3C) - это организация, отвечающая за разработку стандартов для Всемирной паутины, в том числе для HTML. По мере усложнения веб-страниц и веб-приложений W3C обновляет стандарты HTML.

HTML5 Представляет множество семантических элементов. Хотя мы обсуждали HTML, помогли предоставить смысл нашему документу, только до тех пор, пока HTML5 не представит [семантические элементы,](#) что его «потенциал» был реализован.

## Простой пример HTML-документа

```html

<!DOCTYPE html> 
 <html> 
 <head> 
  <title>Page Title</title> 
 </head> 
 <body> 
 
  <h1>My First Heading</h1> 
  <p>My first paragraph.</p> 
 
 </body> 
 </html> 
```

! DOCTYPE html: Определяет этот документ как HTML5

html: Корневой элемент HTML-страницы

head: элемент содержит метаинформацию о документе

title: Элемент указывает заголовок для документа

body: элемент содержит видимое содержимое страницы

h1: Элемент определяет большой заголовок

p: Элемент определяет абзац

### Версии HTML

С первых дней существования Интернета было много версий HTML

|Версия|Год|
|--- |--- |
|HTML|1991|
|HTML 2.0|1995|
|HTML 3.2|1997|
|HTML 4.01|1999|
|XHTML|2000|
|HTML5|2014|

#### Другие источники

*   [Элементы HTML](https://guide.freecodecamp.org/html/elements)
*   [Семантический HTML](https://guide.freecodecamp.org/html/html5-semantic-elements)
*   [Атрибуты HTML](https://guide.freecodecamp.org/html/attributes)
