---
title: Mailto Links
localeTitle: Ссылки Mailto
---
## Ссылки Mailto

Ссылка mailto - это своего рода гиперссылка ( `<a href=""></a>` ) со специальными параметрами, которая позволяет указать дополнительных получателей, строку темы и / или основной текст.

### Основной синтаксис с получателем:

```html

<a href="mailto:friend@something.com">Some text</a> 
```

### Больше настроек!

#### Добавление темы к этой почте:

Если вы хотите добавить конкретную тему к этому письму, будьте осторожны, чтобы добавить `%20` или `+` везде, где есть пробел в строке темы. Простым способом обеспечить правильное форматирование является использование [декодера / кодировщика URL](https://meyerweb.com/eric/tools/dencoder/) .

#### Добавление основного текста:

Аналогично, вы можете добавить определенное сообщение в основной части сообщения электронной почты: Опять же, пробелы должны быть заменены на `%20` или `+` . После субъекта paramater, любому дополнительному параметру должен предшествовать `&`

Пример: скажите, что вы хотите, чтобы пользователи отправляли электронное письмо своим друзьям о своем прогрессе в Free Code Camp:

Адрес: пусто

Тема: Отличные новости

Тело: Я становлюсь разработчиком

Ссылка на html сейчас:

```html

<a href="mailto:?subject=Great%20news&body=I%20am%20becoming%20a%20developer">Send mail!</a> 
```

Здесь мы оставили mailto empty (mailto :?). Это откроет почтовый клиент пользователя, и пользователь добавит адрес получателя.

#### Добавление большего количества получателей:

Таким же образом вы можете добавить параметры CC и ОЦК. Отделяйте каждый адрес запятой!

Дополнительные параметры должны предшествовать `&` .

```html

<a href="mailto:firstfriend@something.com?subject=Great%20news&cc=secondfriend@something.com,thirdfriend@something.com&bcc=fourthfriend@something.com">Send mail!</a> 
```

#### Дополнительная информация:

[MDN - ссылки электронной почты](https://developer.mozilla.org/en-US/docs/Learn/HTML/Introduction_to_HTML/Creating_hyperlinks#E-mail_links)