---
title: Optional Tags
localeTitle: Дополнительные теги
---
## Дополнительные HTML5 теги

В HTML5 вы можете опустить определенные открывающие и закрывающие теги при определенных условиях. Например, следующий код HTML ...

```html

<!DOCTYPE html> 
 <p>Hello World. 
```

Будет автоматически оценивать ...

```html

<!DOCTYPE html> 
 <html> 
  <head></head> 
  <body> 
    <p>Hello world. 
    </p> 
  </body> 
 </html> 
```

Дополнительные спецификации тегов для наиболее распространенных тегов HTML5 следующие:

*   `html` тег элемента `html` может быть опущен, если первое, что внутри элемента `html` не является комментарием.
*   Конечный тег элемента `html` может быть опущен, если элемент `html` не сразу следует комментарию.
*   А `head` открывающий тег элемента может быть опущен , если элемент пуст, или если первая вещь внутри `head` элемента является элементом.
*   А `head` закрывающий тег элемента может быть опущен , если `head` элемент не сразу после пробела или комментарий.
*   Начальный тег элемента `body` может быть опущен, если элемент пуст, или если первая вещь внутри элемента `body` не является символом пробела или комментарием, за исключением того, что первая вещь внутри элемента `body` - это `meta` , `link` , `script` , `style` , или элемент `template` .
*   Конечный тег элемента `body` может быть опущен, если за элементом body сразу не следует комментарий.

### Больше информации

Чтобы узнать больше о дополнительных тегах HTML5, посетите ![Рекомендации консорциума World Wide Web](https://www.w3.org/TR/html5/syntax.html#optional-tags) ,