---
title: Semantic HTML Elements
localeTitle: Семантические элементы HTML
---
## Семантические элементы HTML

Элемент `<em>` отмечает текст как подчеркнутый над текстом вокруг него. Как правило, браузер выделяет _курсивом курсивом_ , но вы можете добавлять другие стили с помощью CSS.

Семантические элементы HTML предоставляют смысл браузерам, разработчикам и пользователям сайта. В отличие от таких элементов, как `<div>` или `<span>` , семантические элементы, такие как `<header>` и `<footer>` более четко объясняют цель каждого раздела веб-сайта.

### Зачем использовать семантические элементы?

Разработчики используют семантические элементы для улучшения следующего:

*   доступность: помощь вспомогательным технологиям читать и интерпретировать вашу веб-страницу
*   возможность поиска: компьютеры помогают понять ваш контент
*   интернационализация: только 13% мира являются носителями английского языка
*   интероперабельность: помогите другим программистам понять структуру вашей веб-страницы 1

### Полезные семантические элементы

*   `<header>` определяет заголовок для документа или раздела
*   `<footer>` определяет нижний колонтитул для документа или раздела
*   `<nav>` определяет ссылки навигации в документе
*   `<main>` определяет основное содержание документа
*   `<section>` определяет раздел в документе - спецификация определяет это как «тематическую группировку контента, как правило, с заголовком», поэтому вы можете думать о нем как о том, как главу
*   `<article>` определяет статью в документе
*   `<aside>` определяет контент, кроме содержимого страницы
*   `<address>` определяет контактную информацию для автора / владельца документа или статьи
*   `<figure>` определяет автономный контент, например иллюстрации, диаграммы, фотографии, блоки кода и т. д. 2

### Малоизвестные семантические элементы

*   `<bdi>` определяет раздел текста, который может быть отформатирован в другом направлении от другого текста (например, цитата на иврите или арабском языке в англоязычной статье)
*   `<details>` определяет дополнительные сведения, которые люди могут просматривать или скрывать (например, всплывающие подсказки)
*   `<dialog>` определяет диалоговое окно или окно
*   `<figcaption>` определяет подпись для `<figure>`
*   `<mark>` определяет выделенный или выделенный текст.
*   `<menuitem>` определяет команду / пункт меню, которую пользователь может выбрать из всплывающего меню
*   `<meter>` определяет скалярное измерение в пределах известного диапазона (калибр)
*   `<progress>` определяет ход выполнения задачи
*   `<rp>` определяет, что показывать в браузерах, которые не поддерживают рубиновые аннотации
*   `<rt>` определяет объяснение / произношение символов (для восточно-азиатской типографии)
*   `<ruby>` определяет рубиновую аннотацию (для восточно-азиатской типографии)
*   `<summary>` определяет видимый заголовок элемента `<details>`
*   `<time>` определяет дату / время
*   `<wbr>` определяет возможный разрыв строки 2

### источники

1.  [Ли, Мишель. «Обзор семантики HTML5». _CodePen_ . 16 февраля 2016. Доступ: 24 октября 2017 г.](https://codepen.io/mi-lee/post/an-overview-of-html5-semantics)
2.  [Бидокс, Винсент. «Семантические элементы HTML5 и Webflow: основное руководство». _Webflow_ . 16 декабря 2016. Доступ: 24 октября 2017 г.](https://webflow.com/blog/html5-semantic-elements-and-webflow-the-essential-guide)

#### Дополнительная информация:

Для получения дополнительной информации: https://codepen.io/mi-lee/post/an-overview-of-html5-semantics

Обратитесь к [статье MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/em) .