---
title: Embedding Youtube Videos
localeTitle: Встраивание видео Youtube
---
## Встраивание видео Youtube

Вероятно, вы много раз видели встроенные видео на своих любимых сайтах. Сегодня мы поговорим о встраивании видео на YouTube, что очень легко сделать, даже если вы не знаете об этом. Для этого действия мы будем использовать элемент `<frame>` , что очень полезно при встраивании других HTML. Это очень часто используется для продвижения некоторых продуктов в качестве добавок. Обратите внимание, что вы не ограничиваетесь только YouTube - вы также можете экспериментировать с другими документами.

### Элемент `<frame>`

#### С помощью

Вы можете легко разместить выбранное видео с помощью элемента `<frame>` . Но помните, вам также нужно определить высоту и ширину вашего игрока, поэтому мы будем использовать `height` и `width` атрибутов.

Что нам нужно?

*   Видео на YouTube и URL
*   `<frame>` (не забудьте закрыть его!)
*   атрибуты `width` и `height`

```html

<iframe width="420" height="315" 
 src="https://www.youtube.com/watch?v=v8kFT4I31es"> 
 </iframe> 
```

Вставляемые значения рекомендуются, но не стесняйтесь изменять их таким образом, который вы хотели бы.

#### Автовоспроизведение

Что нам делать, если мы хотим, чтобы этот игрок начал автоматически играть? Просто добавьте к своей ссылке значение `?autoplay=1` . Но будьте осторожны, потому что это может раздражать многих людей, посещающих вашу веб-страницу.

```html

<iframe width="420" height="315" 
 src="https://www.youtube.com/watch?v=v8kFT4I31es?autoplay=1"> 
 </iframe> 

```