---
title: How to Use Lists
localeTitle: Как использовать списки
---
## Как использовать списки

Списки используются для указания набора последовательных элементов или связанной информации в хорошо сформированном и семантическом смысле, таких как список ингредиентов или список процедурных шагов. HTML-разметка имеет три разных типа списков - **упорядоченные** , **незавершенные** и **описательные** списки.

### Упорядоченные списки

Упорядоченный список используется для группировки набора связанных элементов в определенном порядке. Этот список создается с `<ol>` . Каждый элемент списка окружен `<li>` .

##### Код

```html

<ol> 
    <li>Mix ingredients</li> 
    <li>Bake in oven for an hour</li> 
    <li>Allow to stand for ten minutes</li> 
 </ol> 
```

##### пример

1.  Смешать ингредиенты
2.  Выпекать в духовке в течение часа
3.  Дать постоять десять минут

### Неупорядоченные списки

Неупорядоченный список используется для группировки набора связанных элементов, в определенном порядке. Этот список создается с `<ul>` . Каждый элемент списка окружен `<li>` .

##### Код

```html

<ul> 
    <li>Chocolate Cake</li> 
    <li>Black Forest Cake</li> 
    <li>Pineapple Cake</li> 
 </ul> 
```

#### пример

*   Шоколадный торт
*   Торт черный лес
*   Ананасовый торт

### Описание Списки

Список описаний используется для указания списка терминов и их описаний. Этот список создается с `<dl>` . Каждый элемент списка окружен `<dd>` .

##### Код

```html

<dl> 
    <dt>Bread</dt> 
    <dd>A baked food made of flour.</dd> 
    <dt>Coffee</dt> 
    <dd>A drink made from roasted coffee beans.</dd> 
 </dl> 
```

##### Вывод

Хлеб

Запеченная еда из муки.

Кофе

Выпейте из жареных кофейных зерен.

#### Список стилей

Вы также можете управлять стилем списка. Вы можете использовать свойство `list-style` для списков. Ваш список может быть пулями, квадратами, в римских цифрах или может быть изображениями, которые вы хотите.

Свойство `list-style` является сокращением для `list-style-type` `list-style-position` `list-style-image` .

#### Дополнительная информация:

\[HTML-списки · Документы WebPlatform\] (https://webplatform.github.io/docs/guides/html\_lists/ )