---
title: Images in HTML
localeTitle: Изображения в HTML
---
## Введение

Вы можете определять изображения с помощью `<img>` . Он не имеет закрывающего тега, поскольку он может содержать только атрибуты. Чтобы вставить изображение, вы определяете источник и альтернативный текст, который отображается, когда изображение не может быть отображено.

`src` - этот атрибут предоставляет URL-адрес для изображения, представленного на вашем ПК / ноутбуке, или для включения в какой-либо другой веб-сайт. Помните, что ссылка не должна быть нарушена, иначе изображение не будет создано на вашей веб-странице.

`alt` - Этот атрибут используется для преодоления проблемы сломанного изображения или неспособности вашего браузера не создавать изображение на веб-странице. Этот атрибут как имя предполагает предоставление «Альтернативы» изображению, которое является некоторым «ТЕКСТОМ», описывающим изображение

## пример

```html

<img src="URL of the Image" alt="Descriptive Title" /> 
```

### Чтобы определить высоту и ширину изображения, вы можете использовать атрибут height и width:

```html

<img src="URL of the Image" alt="Descriptive Title" height="100" width="150"/> 
```

### Вы также можете определить толщину границы (0 означает отсутствие границы):

```html

<img src="URL of the Image" alt="Descriptive Title" border="2"/> 
```

### Выравнивание изображения:

```html

<img src="URL of the Image" alt="Descriptive Title" align="left"/> 
```

### Вы также можете использовать стили в атрибуте стиля:

```html

<img src="URL of the Image" alt="Descriptive Title" style="width: 100px; height: 150px;"/> 
```

#### Больше информации

*   Смотрите страницу freeCodeCamp на `<img>` тег [здесь](https://guide.freecodecamp.org/html/elements/img-tag) .
*   Чтобы получить более подробную информацию о изображениях в HTML, ознакомьтесь с [документами MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Img)