---
title: Text Formatting in HTML
localeTitle: Форматирование текста в HTML
---
## Форматирование текста в HTML

HTML предоставляет вам множество полезных элементов для форматирования текста. Это позволяет сделать ваш текст: жирный, курсив, знак и многое другое. Изменение стиля вашего текста не имеет никакой причины - главное - просто заставить читателя взглянуть на важные заметки.

### Жирный и сильный

Вы можете легко изменить свой смысл текста, используя элемент HTML `<b>` . Это делает слова полужирным, какая функция выделяет фрагмент последовательности. Например:
```
The most important part of your code is <b>the end</b>, because if you <b>don't close</b> the element, it will affect to <b>everything</b>! 
```

Вы также можете использовать `<strong>` что добавляет также семантическое «сильное» значение. Ваш браузер не распознает разницу между этими двумя элементами, но он существует.

### Курсив и подчеркнуто

Обычно используется при цитировании чего-либо или перевод слова в множество статей. Это делает их курсивом - просто представьте, что вы пинали правильные буквы. Например:
```
Theatre - <i>teatos</i>, <i>teates</i> and <i>teatron</i>. 
```

Вы также можете использовать `<em>` - он добавляет также смысловое «подчеркнутое» значение. Ваш браузер не распознает разницу между этими двумя элементами, но он существует.

### Маленький

Это делает ваш текст меньше обычного шрифта. Значение этого элемента было изменено в HTML5 - оно представляет побочные комментарии и мелкий шрифт.

`Normal, <small>small</small>, normal, <small>small</small>!`

### отмеченный

Элемент `<mark>` делает ваш текст отмеченным - другими словами, он выделяет ваш текст. Вы можете использовать его, чтобы сообщить читателям, что это одна из важных вещей в вашей статье. Например:

`HTML is full of things and <mark>it's our journey</mark> to get known them better!`

### удаленный

Элемент `<del>` делает ваш текст застрял в центре. Полезно показывать изменения в ваших документах.

`WWI started in <del>1913</del> 1914 year.`

### вставленный

Тег `<ins>` делает ваш текст вставленным в статью. Используя другие слова, которые значительно облегчают понимание - добавлены. Он показывает строку под вставленным текстом.

`HTML isn't boring. <ins>You can make a lot of combinations of elements!</ins>`

### подстрочных

Использование элемента `<sub>` дает полезное форматирование в виде подстрочного текста (показывая его меньше внизу). Существует пример кода:

`This was in 2003 year <sub>(needs a link).`

### верхний индекс

Если вы хотите сделать противоположное подстрочному тексту, вы можете легко использовать элемент `<sup>` . Он показывает меньший текст сверху.

`10<sup>x+y</sup> = 1000`