---
title: UTF 8 Reference
localeTitle: Ссылка UTF 8
---
## Ссылка UTF 8

UTF 8 - это схема кодирования, используемая для перевода символов, которые мы видим на экранах, на номера, которые могут хранить компьютеры. Указание кодировки символов, такой как UTF8, позволит браузеру правильно отображать расширенные символы, такие как акцентированные буквы и эможи.

В документах HTML вы можете указать кодировку символов на странице, поместив этот метатег в `head` тег вашей HTML-страницы: `<meta charset="UTF-8">` . UTF 8 является стандартным кодированием.

Стандарт [Unicode](https://www.unicode.org/) был разработан для размещения персонажей, используемых на разных языках по всему миру.

Но ждать! Что делает Unicode для UTF 8? UTF 8 является схемой кодирования, но важно понимать, что Unicode - это определение набора символов. Говоря простым языком, это означает, что Unicode определяет уникальный номер - называемый точкой кода - для многих основных символов, используемых в языках по всему миру, и UTF 8 будет транслировать (иначе кодировать) персонажа в дружественный к компьютеру двоичный формат. 1 Вот пример:

1.  Вы хотите упомянуть freeCodeCamp где-то на вашей веб-странице (потому что, знаете, freeCodeCamp - это 🔥 🔥 🔥).
    
2.  Код символа указывает на заклинание freeCodeCamp, как определено в Unicode:
    
    | f | r | e | e | C | o | d | e | C | a | m | p | | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | : ---: | | 102 | 114 | 101 | 101 | 67 | 111 | 100 | 101 | 67 | 97 | 109 | 112 |
    
3.  UTF 8 переводит кодовые точки в двоичные: 1100110 1110010 1100101 1100101 1000011 1101111 1100100 1100101 1000011 1100001 1101101 1110000
    

### Как использовать UTF-8 на своей веб-странице

Укажите метатег с кодировкой UTF 8 в теге заголовка.

```html

<head> 
  <meta charset="utf-8"> 
 </head> 
```

#### Дополнительная информация:

*   [Графики кода символов Юникода](https://www.unicode.org/charts/index.html)
*   [Ссылка HTML Unicode](https://www.w3schools.com/charsets/ref_html_utf8.asp)