---
title: Abstract Classes in Java
localeTitle: Абстрактные классы в Java
---

Давайте обсудим абстрактные классы. Прежде чем приступить к этому уроку, вам необходимо хорошо разобраться в понятиях класс и наследование.

Абстрактные классы - это классы, которые могут быть унаследованы (т.е. расширены, ключевое слово **extends**), но не могут быть проинициализированы (созданы). Их можно представить как **классовую версию** интерфейса, или думать о них как о интерфейсе, в методах которого присутствует код.

Чтобы понять абстрактные классы рассмотрим следующий пример: У вас есть класс Vehicle, который определяет определенные базовые функции (методы) и определенные компоненты (поля объекта), которые должны иметь машины, чтобы их классифицировали как транспортное средство. Вы не можете создать объект транспортного средства, потому что само транспортное средство является абстрактным понятием. Однако вы можете расширить функциональность класса автомобиля, чтобы создать автомобиль или мотоцикл.

``` java
//абстрактный класс ТранспортноеСредство
abstract class Vehicle
{
  //переменная, показывающая количество колес у траспортного средства
  private int wheels;
  
  //переменная, определяющая тип мотора
  private Motor motor;
  
  //переменная, которая объявляет, но не определяет старт транспортного средства
  //по причине того, что каждое транспортное средство использует разные механизмы 
  abstract void start();
}

//класс Автомобиль наследует ТранспортноеСредство
public class Car extends Vehicle
{
  ...
}

//класс Мотоцикл наследует ТранспортноеСредство
public class Motorcycle extends Vehicle
{
  ...
}

```
Вы не можете создать объект класса ТранспортноеСредство в вашей программе. Однако, Вы можете унаследовать этот абстрактный класс и создать объект классов его наследников. 

``` java
Vehicle newVehicle = new Vehicle();    // неверно, т.к. невозможно создать объект абстрактного класа
Vehicle car = new Car();  // верно
Vehicle mBike = new Motorcycle();  // верно


Car carObj = new Car();  // верно
Motorcycle mBikeObj = new Motorcycle();  // верно
```
Если дочерний класс не реализует методы родительского абстрактного класса, этот дочерний класс становится также абстрактным.

