---
title: ArrayList
localeTitle: ArrayList
---
# ArrayList

ArrayList является частью  _Framework Collection_.

Структура _Collection_ состоит из всех интерфейсов и классов, которые могут содержать набор значений (аналогично [массивам](https://docs.oracle.com/javase/tutorial/java/nutsandbolts/arrays.html) ). **ArrayList** - это класс, который находится в этой иерархии и известен как _**объект Collection**_ . Он реализует интерфейс _List,_ который, в свою очередь, реализует интерфейс _Collection_ . Этот интерфейс _Collection_ можно найти в пакете `java.util` . Вам нужно будет импортировать этот пакет.

ArrayList - это класс, который используется для создания динамических массивов. Он медленнее, чем обычные массивы, но допускает много манипуляций. Его можно инициализировать, чтобы иметь определенный размер, или он будет иметь размер по умолчанию 10 единиц.

`java ArrayList<String> names = new ArrayList<>(); ArrayList<Integer> ages = new ArrayList<>(5);`

В приведенном выше фрагменте угловые скобки `<>` принимают общий тип данных как аргумент, определяющий тип данных элементов в ArrayList. В первом `names` ArrayList указан как содержащий элементы _String_ . Таким образом, он будет содержать только элементы String. Его размер не указан, поэтому его размер по умолчанию равен 10. Во втором `ages` ArrayList указано, что он будет содержать только целые числа. Но ArrayList не может содержать примитивы, он содержит только объекты. Таким образом, чтобы он может хранить integers, floats и т.д., мы можем использовать классы-оболочки. ArrayList `names` будет иметь заданный размер равный 5.

Поскольку ArrayList реализует _List_ , ArrayList может быть создан с использованием следующего синтаксиса: `java List<Integer> students = new ArrayList<>();`

ArrayList является динамическим массивом, то есть он будет увеличиваться по размеру, если это потребуется, и аналогичным образом уменьшит свой размер, если элементы будут удалены из него. В этом и состоит его преимущество перед обычными массивами.

ArrayList позволяет нам случайным образом обращаться к элементам. ArrayList очень похож на _Vector_ во многих отношениях. Но он быстрее, чем Vectors. Также нужно отметить, что Vectors быстрее чем другие массивы, но ArrayLists - нет.

Поэтому, когда дело доходит до выбора между ними - если скорость крайне высокая, следует использовать Vectors, иначе лучше использовать ArrayLists, когда дело доходит до хранения большого количества элементов и эффективного доступа к ним.
