---
title: Arrays
localeTitle: Массивы
---
# массив

Массив представляет собой набор значений (или объектов) похожих типов данных (примитив и ссылка на оба вида типов данных разрешены), которые хранятся в адресах последовательной памяти. Массив используется для хранения коллекции похожих типов данных. Массивы всегда начинаются с индекса 0 и создаются с заданным числом индексов. Все переменные в массиве должны быть одного типа, объявленного при создании экземпляра.

**Синтаксис:**

```java
dataType[] arrayName;   // preferred way 
```

Здесь `java datatype[]` описывает, что все переменные, указанные после него, будут созданы как массивы указанного типа данных. Итак, если мы хотим создать экземпляр большего массива аналогичного типа данных, нам просто нужно добавить их после указанного `java arrayName` (не забудьте разделить их только через запятую). Пример приведен ниже в следующем разделе для справки.

```java
dataType arrayName[];  //  works but not preferred way 
```

Здесь `java datatype` описывает только то, что переменные, указанные после него, относятся к этому типу данных. Кроме того, `java []` после имени переменной описывает, что переменная представляет собой массив указанного типа данных (а не только значение или объект этого типа данных). Итак, если мы хотим создать экземпляр большего массива аналогичного типа данных, мы добавим имена переменных сразу после уже указанного, разделенные запятыми, и каждый раз нам придется добавлять `java []` после имени переменной, иначе переменная будет экземпляр как обычная переменная хранения значений (а не массив). Для лучшего понимания пример приведен в следующем разделе.

## Фрагменты кода выше синтаксиса:

```java
double[] list1, list2; // preferred way 
```

Над фрагментом кода создается два массива двойных имен типов list1 и list2.

```java
double list1[], list2; // works but not preferred way 
```

Над фрагментом кода выделяется массив типа данных double named list1 и простая переменная типа datatype double named list2 (не путайте с именем **list2** . Имена переменных не имеют ничего общего с типом переменной).

Примечание. `double list[]` стиля `double list[]` не является предпочтительным, поскольку он исходит из языка C / C ++ и был принят на Java для размещения программистов на C / C ++. Кроме того, это более читаемо: вы можете прочитать, что это «двойной массив с именем list», отличный от «двойного названного списка, который представляет собой массив»,

## Создание массивов:

```java
dataType[] arrayName = new dataType[arraySize]; 
```

## Фрагменты кода из приведенного выше синтаксиса:

```java
double[] List = new double[10]; 
```

## Другой способ создания массива:

```java
dataType[] arrayName = {value_0, value_1, ..., value_k}; 
```

## Фрагменты кода выше синтаксиса:

```java
double[] list = {1, 2, 3, 4}; 
 
 The code above is equivalent to: 
 double[] list = new double[4]; 
 *IMPORTANT NOTE: Please note the difference between the types of brackets 
 that are used to represent arrays in two different ways. 
```

## Доступ к массивам:

```java
arrayName[index]; // gives you the value at the specified index 
```

## Фрагменты кода выше синтаксиса:

```java
System.out.println(list[1]); 
```

Вывод:
```
2.0 
```

## Изменение массивов:

```java
arrayName[index] = value; 
```

Примечание. После инициализации вы не можете изменить размер или тип массива. Примечание. Однако вы можете сбросить массив так, как показано ниже.

```java
arrayName = new dataType[] {value1, value2, value3}; 
```

## Размер массивов:

Можно найти количество элементов в массиве, используя атрибут length. Здесь следует заметить, что `java length` - это **атрибут** каждого массива, то есть имя переменной, сохраняющее длину переменной. Его нельзя путать для **метода** массива, так как имя такое же, как метод `java length()` соответствующий классам String.

```java
int[] a = {4, 5, 6, 7, 8}; // declare array 
 System.out.println(a.length); //prints 5 
```

## Фрагменты кода выше синтаксиса:

```java
list[1] = 3; // now, if you access the array like above, it will output 3 rather than 2 
```

_Пример кода:_

```java
int[] a = {4, 5, 6, 7, 8}; // declare array 
 for (int i = 0; i < a.length; i++){ // loop goes through each index 
    System.out.println(a[i]); // prints the array 
 } 
```

Вывод:

```java
    4 
    5 
    6 
    7 
    8 
```

### Многомерные массивы

Двумерные массивы (2D-массивы) можно рассматривать как таблицу со строками и столбцами. Хотя это представление является лишь способом визуализации массива для лучшего решения проблем. Значения фактически сохраняются только в последовательных адресах памяти.

```java
int M = 5; 
 int N = 5; 
 double[][] a = new double [M][N]; //M = rows N = columns 
 for(int i = 0; i < M; i++) { 
    for (int j = 0; j < N; j++) { 
        //Do something here at index 
    } 
 } 
```

Этот цикл будет выполнять M ^ N раз и построит это:

\[0 | 1 | 2 | 3 | 4\]  
\[0 | 1 | 2 | 3 | 4\]  
\[0 | 1 | 2 | 3 | 4\]  
\[0 | 1 | 2 | 3 | 4\]  
\[0 | 1 | 2 | 3 | 4\]

Аналогичным образом можно также создать 3D-массив. Его можно представить в виде кубоида вместо прямоугольника (как указано выше), разделенного на кубики меньшего размера, причем каждый куб хранит некоторое значение. Его можно инициализировать следующим образом:

```java
int a=2, b=3, c=4; 
 int[][][] a=new int[a][b][c]; 
```

Аналогичным образом, массив, имеющий столько же размеров, сколько он хочет, но визуализирующий массив из более чем трех измерений, трудно визуализировать определенным образом.

### Жесткие массивы

Жесткие массивы - это многомерные массивы, которые имеют заданное количество строк, но различное количество столбцов. Жесткие массивы используются для экономии памяти в массиве. Вот пример кода:

```java
int[][] array = new int[5][]; //initialize a 2D array with 5 rows 
 array[0] = new int[1]; //creates 1 column for first row 
 array[1] = new int[2]; //creates 2 columns for second row 
 array[2] = new int[5]; //creates 5 columns for third row 
 array[3] = new int[5]; //creates 5 columns for fourth row 
 array[4] = new int[5]; //creates 5 columns for fifth row 
```

Вывод:

\[0\]  
\[0 | 1\]  
\[0 | 1 | 2 | 3 | 4\]  
\[0 | 1 | 2 | 3 | 4\]  
\[0 | 1 | 2 | 3 | 4\]

#### Дополнительная информация:

*   Источник: [Java-массивы](https://docs.oracle.com/javase/tutorial/java/nutsandbolts/arrays.html)