---
title: bitwise operator example
localeTitle: пример побитового оператора
---
# Побитовые операторы

## Таблица истины

![truth table](https://4.bp.blogspot.com/-0KPDI41veH0/V-OtObm_UWI/AAAAAAAAAso/CkTS0zUMGKIjlE3gUD0fMhmp-B0zcfBmACLcB/s1600/Bitwise-truthtable-Javaform.jpg "таблица истинности")

Побитовые операторы аналогичны логическим операторам, за исключением того, что они работают в меньшем масштабе - двоичные представления данных. Любые данные могут быть преобразованы в бинарный эквивалент. Хотя двоичные операторы работают на двоичном уровне, но они работают только между нормальными десятичными значениями.

## Типы побитовых операторов

### Побитовое ИЛИ

Побитовое ИЛИ является двоичным оператором (работает с двумя операндами). Это обозначается |. | оператор сравнивает соответствующие биты двух операндов. Если любой из бит равен 1, он дает 1. Если нет, он дает 0.

### Побитовое И

Побитовое И является двоичным оператором (работает с двумя операндами). Это обозначается символом &. Оператор & сравнивает соответствующие биты двух операндов. Если оба бита равны 1, он дает 1. Если один из битов не равен 1, он дает 0.

### Побитовое дополнение

Побитовое дополнение является унарным оператором (работает только с одним операндом). Он обозначается через ~. Оператор ~ инвертирует бит-шаблон. Он составляет от 0 до 1 и от 1 до 0.

### Побитовое XOR

Побитовое XOR является двоичным оператором (работает с двумя операндами). Это обозначается через ^. Оператор ^ сравнивает соответствующие биты двух операндов. Если соответствующие биты отличаются друг от друга, это дает 1. Если соответствующие биты одинаковы, он дает 0.

### Сдвиг влево

Оператор сдвига влево << сдвигает бит влево на определенное количество заданных бит, а нулевые биты сдвигаются в позиции низкого порядка.

### Правый сдвиг

Оператор правого сдвига >> сдвигает битовый шаблон вправо на определенное количество указанных битов. Если число является номером, дополненным дополнением 2, бит знака смещается в позиции высокого порядка.

### Беззнаковый правый сдвиг

Беззнаковый оператор сдвига вправо >>> сдвигает ноль в крайнее левое положение.

### Пример побитовых операторов:

```java
    int a = 60;          /* 60 = 0011 1100 represents 60 in binary*/ 
    int b = 13;          /* 13 = 0000 1101 */ 
    int c = 0; 
 
    c = a & b;        /* 12 = 0000 1100 */ 
    c = a | b;        /* 61 = 0011 1101 */ 
    c = a ^ b;        /* 49 = 0011 0001 */ 
    c = ~a;           /*-61 = 1100 0011  :Invert all bits */ 
 
    // shift operators : zeros are shifted in to replace the discarded bits 
    c = a << 2;       /* 240 = 1111 0000 : Shift left 2 bits*/ 
    c = a >> 2;       /* 15 = 1111 */ 
    c = a >>> 2;      /* 15 = 0000 1111 : Zero fill right shift*/ 
```

**ДЛЯ ДОПОЛНИТЕЛЬНОЙ ИНФОРМАЦИИ:** [Нажмите здесь](https://docs.oracle.com/javase/tutorial/java/nutsandbolts/op3.html)