---
title: Basic Operations
localeTitle: Основные операции
---
# Основные операции

Java поддерживает следующие операции над переменными:

*   **Арифметика** : `Сложение (+)` , `Вычитание (-)` , `Умножение (*)` , `Деление (/)` , `Вычисление остатка (%)` , `Инкремент (++)` , `Декремент (--)` .
*   **Конкатенация строк** : `+` может использоваться для конкатенации строк, но вычитание `-` в String являетcя недопустимой операцией.
*   **Реляционные:** `Равно (==)` , `Не равно (!=)` , `Больше чем (>)` , `Меньше чем (<)` , `Больше чем или равно (>=)` , `Меньше чем или равно (<=)`
*   **Побитовые:** `Bitwise And (&)` , `Bitwise Or (|)` , `Побитовое XOR (^)` , `Побитовый комплемент (~)` , `Left shift (<<)` , `Right Shift (>>)` , `Zero fill right shift (>>>)`
*   **Логические:** : `Logical And (&&)` , `Logical Or (||)` , `Logical Not (!)`
*   **Назначения:** : `=` , `+=` , `-=` , `*=` , `/=` , `%=` , `<<=` , `>>=` , `&=` , `^=` , `|=`
*   **Другие:** : `Conditional/Ternary(?:)` , `instanceof`

Хотя большинство операций не требуют пояснений, Условный (тройной) оператор работает следующим образом:

`выражение, результатом которого является boolean output ? возвращает это значение если true : возвращает это значение если false;`

Пример: 
Истинное состояние:

```java
    int x = 10; 
    int y = (x == 10) ? 5 : 9; // y будет равен 5 с тех пор как x == 10 что оценивается как true
```

Ложное Состояние:

```java
    int x = 25; 
    int y = (x == 10) ? 5 : 9; // y будет равен 9 с тех пор как x == 10 что оценивается как false
```

Экземпляр оператора используется для проверки типов. Его можно использовать для проверки, является ли объект экземпляром класса, подкласса или интерфейса. Общий формат - _**экземпляр** объекта класса / подкласса / интерфейса_

Вот программа для иллюстрации instanecof оператора: \`\` \`Java Person obj1 = new Person (); Person obj2 = new Boy ();
```
    // Поскольку obj имеет тип person, он он не является
    // экземпляром Boy или interface
    System.out.println("obj1 instanceof Person: " +  (obj1 instanceof Person)); /*возвращает true с тех пор как obj1 является экземпляром person */ 
```

\`\` \`
