---
title: Comments in Java
localeTitle: Комментарии в Java
---
## Комментарии в Java

Комментарии в java похожи на заметки в реальной жизни, которые используются для отображения некоторой информации, которую другие программисты или разработчики могут читать и понимать.

Хорошая практика - добавлять комментарии к вашему коду, особенно при работе с командой или в компании. Это помогает будущим разработчикам или товарищам по команде легче понять, что происходит в вашем коде. Комментарии делают ваш код более аккуратным и организованным.

Комментарии Java не выполняются компилятором и интерпретатором.

### Типы комментариев Java

#### 1\. Одиночный комментарий


Чтобы создать однострочный комментарий просто добавьте два `//` слэша перед текстом.

```java
// Это пример того, как как выглядит однострочный комментарий

```

#### 2\. Многострочный комментарий


Чтобы создать многострочный комментарий, напишите ваши строки между `/*` линиями здесь `*/`


```java
public class MyFirstJava { 
    public static void main(String[] args) { 

    /* Этот Java код 
       Выводит на консоль "Hello world" 
       и вы читаете многострочный комментарий 

    */ 
        System.out.println("Hello World"); 
    } 
 } 
```

#### 3\. Комментарий к документации


Комментарий к документации используется инструментом Javadoc для создания документации для кода. Комментарий документации используется разработчиками для документирования кода, например, что какие функции выполняет класс или что делает метод. Это используется инструментом javadoc, который будет компилировать предварительно отформатированный набор html-файлов, содержащих всю информацию, доступную в комментарии.

```java
/** 
 * Эта программа выводит случайное число от 0 до 50 в консоль 
 * Большинство разработчиков не документируют такие простые программы

 * 
 * @автор      Quincy Larson 
 * @версия     1.0 
 */ 
 
 public class RandomNumbers{ 
    public static void main(String[] args) { 
        int random = (int)(Math.random() * 50 + 1); 
        System.out.println("Hello World"); 
    } 
 } 
```

#### Дополнительная информация:

*   [Ресурсы Java](http://guide.freecodecamp.org/java/resources/)
    
*   [Скомпилированный пример Javadoc](https://docs.oracle.com/javase/8/docs/api/)
