---
title: Defining Attributes
localeTitle: Определение атрибутов
---
## Определение атрибутов

Класс имеет атрибуты и методы. Атрибуты являются в основном переменными внутри класса.

**_Пример:_**

```java
public class Vehicle { 
  int maxSpeed; 
  int wheels; 
  String color; 
 
  void horn() { 
    System.out.println("Beep beep!"); 
  } 
 } 
```

`maxSpeed` , `wheels` и `color` - все атрибуты нашего класса Vehicle, а метод `horn()` - единственный.

### Создание объектов

Мы можем создать несколько объектов нашего класса Vehicle и использовать точечный синтаксис для доступа к их атрибутам и методам.

```java
class MyClass { 
  public static void main(String[] args) { 
    Vehicle v1 = new Vehicle(); 
    Vehicle v2 = new Vehicle(); 
    v1.color = "red"; 
    v2.horn(); 
  } 
 } 
```

### Модификаторы видимости

В приведенном выше примере транспортного средства атрибуты объявляются без модификатора видимости (например, открытого, закрытого или защищенного). Когда модификатор не включен в разделение атрибута, он по умолчанию имеет значение, называемое «private package», что означает, что к этому атрибуту можно получить доступ напрямую, используя «.». точечная нотация любым другим классом внутри одного пакета.

Доступ к «общедоступным» переменным можно получить из любого класса «Защищенные» переменные могут быть доступны любым классом внутри одного и того же пакета, а также подклассами в любых других пакетах, имеющих родительские дочерние отношения «частные» переменные могут быть доступны только из класса, в котором они объявлены Доступ к частным частям пакета можно получить по классам в одном пакете

«public», переменные, методы, конструкторы и классы (только один) объявляются как общедоступные. «protected», переменные, методы и конструкторы могут быть объявлены частными, а не классами и интерфейсами. «private», переменные, методы и конструкторы могут быть объявлены частными, а не классами и интерфейсами. «default», переменные, методы, конструкторы и классы могут быть типа по умолчанию (объявлены, не записывая ничего).

#### public> protected> default> private (на основе удобства доступности)

Как правило, рекомендуется использовать все атрибуты класса private и контролировать доступ к ним с помощью методов «getter» и «setter».