---
title: Checking for Equality
localeTitle: Проверка равенства
---
# Проверка равенства

В Java существует два способа проверить, являются ли две переменные «одинаковыми»: `==` и `.equals()` . Однако эти методы работают не одинаково.

## Оператор `==`

Основная операция равенства в Java, `==` как в `var1 == var2` , проверяет, указывают ли `var1` и `var2` одну и ту же _ссылку на объект_ . То есть, если `var1` является одним и тем же _экземпляром_ класса в памяти как `var2` , то `var1 == var2` является истинным.

Однако, если `var1` и `var2` были созданы как два отдельных экземпляра класса (т.е. с `new` ключевым словом), то `var1 == var2` будет false. Даже если оба объекта содержат одни и те же свойства и значения, сравнение `==` не пройдет, потому что они не указывают на один и тот же объект в памяти.

Для примитивных типов переменных, таких как `int` и `double` , оператор `==` всегда может использоваться для проверки равенства, так как их значения хранятся непосредственно с переменной (а не как ссылка на другой слот в памяти).

```java
int var1 = 1; 
 int var2 = 1; 
 System.out.println(var1 == var2) // true 
 
 MyObject obj1 = new MyObject(); 
 MyObject obj2 = obj1; 
 MyObject obj3 = new MyObject(); 
 
 System.out.println(obj1 == obj2) // true 
 System.out.println(obj1 == obj3) // false 
 System.out.println(obj2 == obj3) // false 
```

## Метод `.equals()`

Встроенный класс `Object` в Java, который все остальные классы автоматически расширяют, содержит ряд полезных встроенных методов. Одним из таких методов является `equals()` , который принимает в качестве своего аргумента другой объект и возвращает, следует ли считать два объекта «равными» в соответствии с соответствующей логикой для этого класса.

Класс String является одним из наиболее распространенных примеров класса, который переопределяет метод equals (). При сравнении двух «строк для равенства» вам нужно использовать метод «equals ()», поскольку «==» не будет работать так, как вы ожидаете.

```java
String s1 = "Bob"; 
 String s2 = "ob"; 
 s2 = "B" + s2; //s2 теперь тоже "Bob" 
 System.out.println(s1 == s2); //false 
 System.out.println(s1.equals(s2)); //true 
```

Когда вы создаете новый класс в Java, вам часто нужно переопределить метод `equals()` , чтобы обеспечить более осмысленный способ сравнения двух объектов одного и того же класса. Как этот метод реализован - полностью зависит от суждения разработчика.

Например, вы можете решить, что два `Person` должны считаться «равными», если их `name` и `dateOfBirth` одинаковы. Эта логика будет реализована в методе `equals()` класса `Person` :

```java
public class Person { 
    public String name; 
    public Date dateOfBirth; 
 
    public boolean equals(Person person) { 
        return this.name.equals(person.name) && this.dateOfBirth.equals(person.dateOfBirth); 
    } 
 } 
```

Большинство встроенных классов в Java, а также классы, предоставляемые популярными библиотеками, будут реализовывать метод `equals()` подобным образом.

Например, интерфейс `java.util.Set` указывает, что метод `equals()` `Set` возвращает true, если «указанный объект также является множеством, два множества имеют одинаковый размер и каждый член указанного множества содержится в этом наборе».

Однако, если класс не переопределяет реализацию `equals()` по умолчанию, применяется реализация по умолчанию, которая просто использует оператор `==` для сравнения двух объектов.
