---
title: Exceptions in Java
localeTitle: Исключения в Java
---
## Что такое исключение?

Исключением является нежелательное или неожиданное событие, которое происходит во время выполнения программы, то есть во время выполнения, что нарушает нормальный поток инструкций программы.

## Ошибка против исключения

Ошибка: ошибка указывает на серьезную проблему, которую разумное приложение не должно пытаться поймать. Исключение: Исключение указывает условия, которые разумное приложение может попытаться поймать.

## Иерархия исключений

Все типы исключений и ошибок являются подклассами класса Throwable, который является базовым классом иерархии. Одна ветвь возглавляет Exception. Этот класс используется для исключительных условий, которые пользовательские программы должны улавливать. NullPointerException - пример такого исключения. Другая ветка, ошибка используется системой времени выполнения Java (JVM), чтобы указать на ошибки, связанные с самой средой времени выполнения (JRE). StackOverflowError является примером такой ошибки.

## Как использовать предложение try-catch
```
try { 
 // block of code to monitor for errors 
 // the code you think can raise an exception 
 } 
 catch (ExceptionType1 exOb) { 
 // exception handler for ExceptionType1 
 } 
 catch (ExceptionType2 exOb) { 
 // exception handler for ExceptionType2 
 } 
 // optional 
 finally { 
 // block of code to be executed after try block ends 
 } 

```