---
title: Garbage Collection
localeTitle: Сборщик мусора
---
# Сборщик мусора в Java

В таких языках, как C / C ++, создавать и уничтожать объекты - обязанность разработчика. Но если программист не выполняет свой долг, может возникнуть недостаток памяти для создания объекта, и программа может закончиться **вызовом OutOfMemoryErrors** .

Java освобождает программиста от задачи управления памятью и сама восстанавливает память, занятую объектами, которые больше не используются. Сбор мусора в java осуществляется потоком-демоном, называемым **сборщиком мусора** . **JVM (виртуальная машина Java)** вызывает его, когда появляется нехватка памяти (в куче) для новых объектов.

## Когда объект становится пригодным для сбора мусора?

*   Объект становится пригодным для сбора мусора, если он недоступен ни для каких живых потоков или каких-либо статических ссылок.
*   Объект становится пригодным для сбора мусора, если все ссылки являются `null`.

```java
         Integer n = new Integer(); 
         n = null;                                //объект класса Integer больше не доступен
```

*   Циклические зависимости не считаются ссылкой, поэтому, если объект X ссылается на объект Y, а объект Y ссылается на объект X, и у них нет никаких других живых ссылок, то оба объекта X и Y уйдут в сборщик мусора.

## Как вручную сделать объект подходящим для сбора мусора?

*   Несмотря на то, что уничтожение объектов не входит в задачи программиста, сделать проект недоступным после его использования (а значит и пригодным для сборщика мусора) является хорошей практикой программирования.
*   Как правило, существует четыре разных способа сделать объект подходящим для сбора мусора.

1.  Обнуление ссылочной переменной
2.  Повторное присвоение ссылочной переменной
3.  Объект создается внутри блока, и ссылка выходит за пределы области действия после того, как управление выйдет из этого блока.
4.  [Остров изоляции](http://www.geeksforgeeks.org/island-of-isolation-in-java/)

## Способы обращения к JVM для запуска сборщика мусора 1

*   Хотя создание объекта, имеющего право на сбор мусора, зависит от единственного усмотрения JVM, чтобы запустить сборщик мусора, чтобы его уничтожить.
*   Мы также можем запросить JVM запустить сборщик мусора. Это можно сделать двумя способами:

1.  Использование метода _**System.gc ()**_ : системный класс содержит статический метод gc() для запроса JVM для запуска сборщика мусора.
2.  Использование _**метода Runtime.getRuntime().gc()**_ : класс Runtime позволяет приложению взаимодействовать с JVM, в котором работает приложение. Следовательно, используя свой метод gc(), мы можем запросить JVM для запуска Collector мусора.

```java
         // Java program to request 
    // JVM to run Garbage Collector 
 public class Test 
 { 
    public static void main(String[] args) throws InterruptedException 
    { 
        Test test1 = new Test(); 
        Test test2 = new Test(); 
 
        // Обнуление ссылки 
        test1 = null; 
 
        // запрос JVM запустить сборщик мусора
        System.gc(); 
 
        // Обнуление ссылочной переменной 
        test2 = null; 
 
        // запрос JVM запустить сборщик мусора
        Runtime.getRuntime().gc(); 
 
    } 
 
    @Override 
    // метод finalize() запускается объектом единожды 
    // перед тем как сборщик мусора уничтожит его и восстановит занимаемую им память 
    protected void finalize() throws Throwable 
    { 
        System.out.println("Garbage collector is called"); 
        System.out.println("Object garbage collected : " + this); 
    } 
 } 
```

```java
  OUTPUT - 
    Garbage collector called 
    Object garbage collected : Test@46d08f12 
    Garbage collector called 
    Object garbage collected : Test@481779b8 
```

Заметка :

1.  Нет никакой гарантии, что любой из двух вышеперечисленных методов определенно будет запускать сборщик мусора.
2.  Вызов System.gc() фактически эквивалентен вызову: Runtime.getRuntime().gc()

## Финализация объектов

*   Объекты имеют ресурсы, связанные с ними. Это их обязанность освобождать ресурсы.
*   Finalize () объявляется в классе Object и вызывается сборщиком мусора один раз, перед уничтожением объекта. Объект может предпринять любое последнее действие, используя этот метод jst, прежде чем его область будет исправлена ​​сборщиком мусора.
*   finalize () присутствует в классе Object со следующим прототипом.

```java
    protected void finalize() throws Throwable 
```

## ПРИМЕЧАНИЕ 1 :

1.  Метод finalize (), вызываемый сборщиком мусора, а не JVM. Хотя Garbage Collector является одним из модулей JVM.
2.  Метод finalize () класса объекта имеет пустую реализацию, поэтому рекомендуется переопределить метод finalize () для утилизации системных ресурсов или для выполнения другой очистки.
3.  Метод finalize () никогда не вызывается более одного раза для любого заданного объекта.
4.  Если исключенное исключение выбрано методом finalize (), исключение игнорируется и завершается завершение этого объекта.

### ИСТОЧНИКИ

1.  [geeksforgeeks.](http://www.geeksforgeeks.org/garbage-collection-java/) Доступ: 24 октября 2017 года.
