---
title: Getters & Setters
localeTitle: Getters & Setters
---
# Getters & Setters

Getters и Setters используются для эффективной защиты ваших данных, особенно при создании классов. Для каждой переменной экземпляра метод getter возвращает свое значение, в то время как метод setter устанавливает или обновляет его значение. Геттеры и сеттеры также известны как аксессоры и мутаторы, соответственно.

По соглашению, getters начинаются с get, за которым следует имя переменной, с первой буквой имени переменной с заглавной буквы. Стартеры начинаются с набора, за которым следует имя переменной, с первой буквой имени переменной с заглавной буквы.

**_Пример:_**

```java
public class Vehicle { 
  private String color; 
 
  // Getter 
  public String getColor() { 
  return color; 
  } 
 
  // Setter 
  public void setColor(String c) { 
  this.color = c; 
  } 
 } 
```

Метод getter возвращает значение атрибута. Метод setter принимает параметр и присваивает его атрибуту.

Как только геттер и сеттер были определены, мы используем его в нашей основной:

```java
public stativ void main(String[] args) { 
  Vehicle v1 = new Vehicle(); 
  v1.setColor("Red"); 
  System.out.println(v1.getColor()); 
 } 
 
 // Outputs "Red" 
```

* * *

Getters и seters позволяют контролировать значения. Вы можете проверить данное значение в настройщике, прежде чем устанавливать значение.

## Почему геттер и сеттер?

Используя геттер и сеттер, программист может контролировать доступ и обновление важных переменных, например изменение значения переменной в заданном диапазоне. Рассмотрим следующий код метода сеттера:

```java
public void setNumber(int num) { 
    if (num < 10 || num > 100) { 
        throw new IllegalArgumentException(); 
    } 
    this.number = num; 
 } 
```

Это гарантирует, что значение числа всегда устанавливается между 10 и 100. Если программист позволяет напрямую изменять значение переменной, вызывающий может установить для него любое произвольное значение:

```java
obj.number = 3; 
```

Это нарушает ограничение для значений от 10 до 100 для этой переменной. Поскольку мы не ожидаем, что это произойдет, скрытие номера переменной как частного и использование setter предотвращает ее. С другой стороны, метод getter - единственный способ для внешнего мира прочитать значение переменной:

```java
public int getNumber() { 
    return this.number; 
 } 

```