---
title: Jump Statements
localeTitle: Перейти к началу страницы
---
# Перейти к началу страницы

Операторы перехода - это тип операторов [_потока управления_](https://docs.oracle.com/javase/tutorial/java/nutsandbolts/flow.html) . В основном вы можете использовать их для изменения порядка выполнения операторов из обычного хода выполнения. По сути, эти утверждения заставляют программный контроль «прыгать» от следующей ожидаемой точки выполнения в другое место в программе.

Следующие операторы перехода обычно используются с циклами:

*   [перерыв](http://forum.freecodecamp.com/t/java-loops-break-control-statement)
*   [Продолжить](http://forum.freecodecamp.com/t/java-loops-continue-control-statement)

Оператор управления «break» выходит из цикла, когда выполняется условие. Это означает, что остальная часть цикла не будет работать. Например, в цикле ниже, если я достигает 5, цикл прерывается, поэтому он не продолжается.

```java
for(int i=0;i<10;i++){ 
 
  if(i == 5){ //if i is 5, break out of the loop. 
    break; 
  } 
 
 System.out.println(i); 
 } 
```

Вывод:
```
    0 1 2 3 4 
```

Операция «continue» является менее интенсивной версией «break». Он только вырывается из текущего экземпляра цикла и продолжается. В цикле ниже, если i равно 5, цикл продолжается, поэтому он пропустит приведенный ниже оператор печати и продолжит движение до тех пор, пока не достигнет 10, и цикл остановится.

```java
for(int i=0;i<10;i++){ 
 
  if(i == 5){ //if i is 5, break out of the current instance loop. 
    continue; 
  } 
 
 System.out.println(i); 
 } 
```

Вывод:
```
    0 1 2 3 4 6 7 8 9 

```