---
title: For Each Loop
localeTitle:  Цикл For Each
---
# Цикл For Each

Также называемый расширением цикла `for` , это чрезвычайно полезный и простой способ перебора каждого элемента в коллекции, массиве или любом объекте, который реализует интерфейс `Iterable` .

```java
for (object : iterable) 
 { 
    // Statements 
 } 
```

Цикл интерпретируется как «для каждого элемента в `iterable` (может быть массив, коллекция и т. д.)». Тип `object` должен соответствовать типу элемента `iterable` .

```java
int[] number_list = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}; 
 
 for (int numbers : number_list) 
 { 
    System.out.print(numbers + " "); 
    // Iterated 10 times, numbers 0,1,2...9 
 } 
```

Вывод:
```
    0 1 2 3 4 5 6 7 8 9 
```

: запустить: [код примера](https://repl.it/CJYs/0)

Сравнивая это с традиционными циклом `for`:

```java
int[] number_list = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}; 
 
 for(int i=0;i < number_list.length;i++) 
 { 
  System.out.print(number_list[i]+" "); 
      // Iterated 10 times, numbers 0,1,2...9 
 
 } 
```

Вывод:
```
    0 1 2 3 4 5 6 7 8 9 
```

: запустить: [код примера](https://repl.it/NJfG/0)

Хотя оба фрагмента кода выполняют одну и ту же работу, очевидно, что у цикла for each есть преимущества в упрощении итерации и доступа к элементам коллекции (массива в нашем случае).

Когда мы использем улучшенный цикл, нам не нужно упоминать начальные и конечные точки цикла, что уменьшает ошибки OutofBounds. Потребность в ручном индексировании удаляется, а читаемость кода улучшается.

Важно отметить, что внесение изменений в переменную итерации для расширенных циклов в цикле не приводит к изменениям исходных элементов коллекции.

Улучшенные  'for' циклы также могут использоваться с многомерными массивами или другими коллекциями в Java. Пример его использования с многомерными массивами показан ниже:

```java
int number_list_new[][]={  {  0,  1, 2}, 
                  {  3, 4, 5}, 
                  { 6, 7, 8} }; 
 
 // Because 2d arrays are implemented as "arrays of arrays",the first iteration variable iterates 
 // through 3 such arrays(that is, the 3 rows of testarr[][]) 
 for(int i[] : number_list_new) 
 { 
  for(int j : i){ 
    System.out.print(j+" "); 
  } 
 } 
```

Вывод:
```
0 1 2 3 4 5 6 7 8 
```

: запустить: [код примера](https://repl.it/NJhP/0)

В приведенных выше фрагментах кода `number_list` является массивом. Если вы не знаете, что это такое, не беспокойтесь об этом. Массив - это контейнерный объект, который содержит фиксированное число значений одного типа, но больше об этом позже.
