---
title: For Loop
localeTitle: Цикл `for`
---
# Цикл `for`

Цикл `for` дает вам компактный способ итерации по целому ряду значений. Базовый `for` оператор состоит из трех частей: инициализации переменных, логическое выражения и выражения инкремента.

```java
for (variable initialization; boolean expression; increment expression) 
 { 
    // Statements 
 } 
```

*   `initialization` - инициализирует цикл и выполняется только один раз, в начале.

Вы можете инициализировать более одной переменной одного типа в первой части декларации цикла `for`; каждая инициализация должна быть разделена запятой.

*   `expression` - оценивается в начале каждой итерации. Если `expression` оценивается как `true` , `Statements` будут выполнены.
*   `increment` - вызывается после каждого прохождения цикла. Здесь вы можете увеличить / уменьшить значение переменных. Убедитесь, что `increment` меняет значение выражения, чтобы избежать бесконечного цикла.

Используйте цикл `for`, если что вам нужно повторить ваш код несколько раз. Например, если вы хотите вывести числа 0-10, вы должны инициализировать переменную для вашего счетчика равную 0, затем проверить, меньше ли это значение, чем 10, и добавить один к счетчику после каждой итерации.

Обратите внимание, что вы проверяете, будет ли значение меньше 10, а не менее или равно 10, так как вы начинаете свой счетчик с 0.

```java
for (int iter_For = 0; iter_For < 10; iter_For++) 
 { 
    System.out.print(iter_For + " "); 
    // Iterated 10 times, iter_For 0,1,2...9 
 } 
 
 System.out.println("iter_For Value: " + iter_For); 
```

Примечание. Также допустимо объявить переменную в цикле for как один оператор.

```java
for (int iter_For = 0; iter_For < 10; iter_For++) 
 { 
    System.out.print (iter_For + " "); 
    // Iterated 10 times, iter_For 0,1,2...9 
 } 
```

Вывод:
```
0 1 2 3 4 5 6 7 8 9 
 iter_For Value: 10 
```

Другой пример цикла for, который добавляет первые 50 номеров, будет таким. i ++ означает i = i + 1.

```java
int addUntil = 50; 
 int sum 0; 
 
 for (int i = 1; i <= addUntil; i++) 
 { 
    sum+=i 
 } 
 
 System.out.println("The sum of the first 50 numbers is: " + 50); 
```

![:запустить:](https://forum.freecodecamp.org/images/emoji/emoji_one/rocket.png?v=2 ": Ракета:") [Код примера](https://repl.it/CJYr/0)

### Дополнительно

Нельзя использовать число (старая конструкция языка C-стиля) или что-либо, что не оценивает логическое значение как условие для оператора if или цикла. Вы не можете, например, сказать if (x), если x не является логической переменной.

Кроме того, важно иметь в виду, что логическое выражение должно в какой-то момент принять значение true. В противном случае ваша программа застрянет в бесконечном цикле.
