---
title: Infinite Loops
localeTitle: Бесконечные циклы
---
# Бесконечные циклы

Бесконечный цикл представляет собой оператор цикла ( `for` , `while` , `do-while` ), который не заканчивается сам по себе.

Условие проверки оператора цикла определяет, будет ли тело цикла выполняться или нет. Таким образом, условие проверки, которое всегда верно, приведет к тому, что тело цикла будет выполняться бесконечно.

Примеры:

```java
// Infinite For Loop 
 for ( ; ; ) 
 { 
    // some code here 
 } 
 
 // Infinite While Loop 
 while (true) 
 { 
    // some code here 
 } 
 
 // Infinite Do While Loop 
 do 
 { 
    // some code here 
 } while (true); 
```

Обычно, если ваш цикл работает бесконечно, это ошибка, которая не должна возникать, поскольку бесконечный цикл не останавливается и предотвращает запуск остальной части программы.

```java
for(int i=0;i<100;i++){ 
 
    if(i==49){ 
    i=0; 
    } 
 
 } 
```

Цикл выше работает бесконечно, потому что каждый раз, когда я приближаюсь к 49, он устанавливается равным 0. Это означает, что я никогда не достигну 100, чтобы завершить цикл, поэтому цикл представляет собой бесконечный цикл.

Программа, застрявшая в таком цикле, будет бесконечно использовать компьютерные ресурсы. Это нежелательно и является типом «ошибки времени выполнения».

Чтобы предотвратить ошибку, программисты используют оператор break для выхода из цикла. 'break' выполняется только при определенном условии. Использование команды выбора, такой как if-else, обеспечивает то же самое.

```java
while (true) 
 { 
    // do something 
 
    if(conditionToEndLoop == true) 
        break; 
 
    // do more 
 } 
```

Основным преимуществом использования бесконечного цикла над регулярным циклом является легкость чтения.

Иногда тело цикла легче понять, если цикл заканчивается посередине, а не в конце / начале. В такой ситуации лучшим выбором будет бесконечный цикл.
