---
title: While Loop
localeTitle:  Цикл while
---
# Цикл while

В `while` цикле блок операторов выполняется до тех пор, пока условие, указанное в скобках, не принимает значение `false`. Например:

```java
while (some_condition_is_true) 
 { 
    // do something 
 } 
```

Каждая «итерация» (выполнения блока операторов) предшествует оценке условия, указанного в круглых скобках. Операторы выполняются только в том случае, если условие имеет значение `true` . Если условие имеет значение `false` , выполнение программы возобновляется из инструкции сразу после блока `while` .

**Примечание:** Чтобы начать выполнение `while` цикла, нужно, чтобы условие изначально имело значение `true`. Однако, чтобы выйти из цикла, вы должны сделать что-то внутри блока операторов, чтобы в итоге достичь итерации, когда условие оценивается как `false` (как показано ниже). В противном случае цикл будет выполняться вечно. (На практике он будет работать до тех пор, пока в [JVM](https://guide.freecodecamp.org/java/the-java-virtual-machine-jvm) не закончится память.)

## пример

В следующем примере условие дается `iter_While < 10` . Мы увеличиваем `iter_While` по `1` каждый раз, когда цикл выполняется. Цикл `while` прерывается , когда `iter_While` значение достигает `10` .

```java
int iter_While = 0; 
 while (iter_While < 10) 
 { 
    System.out.print(iter_While + " "); 
    // Increment the counter 
    // Iterated 10 times, iter_While 0,1,2...9 
    iter_While++; 
 } 
 System.out.println("iter_While Value: " + iter_While); 
```

Вывод:
```
0 1 2 3 4 5 6 7 8 9 
 iter_While Value: 10 
```

![:rocket:](//forum.freecodecamp.com/images/emoji/emoji_one/rocket.png?v=2 ": запустить:") [Код примера](https://repl.it/CJYj/0)
