---
title: Methods
localeTitle: методы
---
# методы

Наиболее узнаваемый метод в Java - это, вероятно, `public static void main(String[]args)` где `public` означает, что пользователи имеют доступ к методу, `static` означает, что метод основан на «классе», а не в «экземпляре», `void` означает что от метода к другому (более высокий уровень) ничего не будет возвращено, а `main` - имя этого конкретного метода.

`getName()` и `getManufacturerName()` - два метода «Getter», которые мы использовали здесь. Как правило, методы в Java состоят из этих частей -

*   Модем доступа (необязательно) - `public` , `private` или `protected` . По умолчанию пакет закрывается, если не указывается
*   Тип возврата. Это требуется, это означает, какое значение возвращает метод, или `void` если ничего не возвращается
*   Имя метода - следует за соглашением camelCase
*   Список параметров - список параметров с их именем и типом, пустой, если параметры не приняты
*   Тело метода, окруженное `{ }`

Кроме того, методы могут также иметь ключевое слово `static` , то есть оно связано с самим классом, а не с экземпляром класса ex- `public static void main()` .

Обратите внимание: в отличие от JavaScript мы **должны** определить тип возвращаемого значения любого метода, который мы пишем, иначе он не будет работать во время компиляции. Если вы не хотите, чтобы метод возвращал что-либо, используйте тип возврата `void` .

Каждый метод имеет подпись, которая представляет собой комбинацию типа данных, имени и количества аргументов, которые принимает метод. В `public static void main` метод не имеет указанного типа данных и вместо этого использует `void` чтобы объявить, что данные не возвращаются. В методе `public static double ave(double val, double val)` тип данных «double» (0.0), имя «ave» (среднее), а метод принимает 2 аргумента. Каждый метод **должен** иметь уникальную подпись.

```java
public class Car { 
    private String name; 
    private String manufacturersName; 
 
    public void changeName() { 
        name = "Tesla"; 
    } 
 
    public String getName(){ 
        return name; 
    } 
 
    public String getManufacurername(){ 
        return manufacturersName; 
    } 
 
 } 
```

Параметры могут быть переданы в методы. Параметры объявляются сразу после имени метода внутри скобок. Синтаксис объявления параметра - \[Тип данных\] \[Имя\].

```java
public class Car { 
    private String name; 
 
    public void changeName(String newName) { 
        name = newName; 
    } 
 } 
```

Как и на любом другом языке, методы (или функции, если вы здесь из мира JS) часто используются для их модульности и повторного использования.

Методы часто служат многим целям, таким как обновление информации в объекте или предоставление данных обратно вызывающему абоненту. Вот несколько примеров.

```java
public class Car { 
    private int numberOfWheels; 
 
    public void setNumberOfWheels(int newNumberOfWheels) { 
        numberOfWheels = newNumberOfWheels; 
    } 
 
    public int getNumberOfWheels() { 
        return numberOfWheels; 
    } 
 } 
```

В случае `getNumberOfWheels()` тип возврата - `int` который является целым числом. `return` ключевого слова сообщает java, чтобы передать значение переменной экземпляра `numberOfWheels` . `setNumberOfWheels(int newNumberOfWheels)` однако, не имеет возвращаемого типа, поскольку это метод сеттера, как это было ранее показано. В этом случае, хотя он принимает аргумент типа `int` и делает экземпляр varible `numberOfWheels` равным `newNumberOfWheels` .

Существует также специальный метод, называемый конструктором, который позволяет устанавливать данные или выполнять операции при создании экземпляра класса. Этот конструктор не имеет типа возврата.

```java
public class Car { 
    private String model; 
    private int numberOfWheels; 
 
    public Car(String model, int numberOfWheels) { 
        this.model = model; 
        this.numberOfWheels = numberOfWheels; 
    } 
 } 
```

Класс `Car` и метод `Car(String model, int numberOfWheels)` должны иметь одно и то же имя, чтобы Java знал, что это конструктор. Теперь, когда вы создаете экземпляр нового экземпляра `Car` с `new` ключевым словом, вам нужно будет вызвать этот конструктор и передать необходимые данные.