---
title: Static
localeTitle: статический
---
# статический

Когда вы объявляете переменную или метод статическими, она принадлежит классу, а не конкретному экземпляру. Это означает, что существует только один экземпляр статического члена, даже если вы создаете несколько объектов класса или если вы его не создаете. Он будет использоваться всеми объектами.

Статическое ключевое слово можно использовать с переменными, методами, блоками кода и вложенными классами.

## Статические переменные

**_Пример:_**

```java
public class Counter { 
  public static int COUNT = 0; 
  Counter() { 
    COUNT++; 
  } 
 } 
```

Переменная `COUNT` будет использоваться всеми объектами этого класса. Когда мы создаем объекты нашего класса Counter в main и получаем доступ к статической переменной.

```java
public class MyClass { 
  public static void main(String[] args) { 
    Counter c1 = new Counter(); 
    Counter c2 = new Counter(); 
    System.out.println(Counter.COUNT); 
  } 
 } 
 // Outputs "2" 
```

Outout равно 2, потому что переменная `COUNT` статична и увеличивается каждый раз при создании нового объекта класса Counter. Вы также можете получить доступ к статической переменной с помощью любого объекта этого класса, такого как `c1.COUNT` .

## Статические методы

Статический метод относится к классу, а не к экземплярам. Таким образом, его можно вызвать без создания экземпляра класса. Он используется для изменения статического содержимого класса. Существуют некоторые ограничения статических методов:

1.  Статический метод не может использовать нестатические элементы (переменные или функции) класса.
2.  Статический метод не может использовать `this` или `super` ключевые слова.

**_Пример:_**

```java
public class Counter { 
  public static int COUNT = 0; 
  Counter() { 
    COUNT++; 
  } 
 
  public static void increment(){ 
    COUNT++; 
  } 
 } 
```

Статические методы также можно вызывать из экземпляра класса.

```java
public class MyClass { 
  public static void main(String[] args) { 
    Counter.increment(); 
    Counter.increment(); 
    System.out.println(Counter.COUNT); 
  } 
 } 
 // Outputs "2" 
```

Выходной сигнал равен 2, поскольку он увеличивается с помощью статического метода `increament()` . Подобно статическим переменным, статические методы также могут быть доступны с использованием переменных экземпляра.

## Статические блоки

Статические блоки кода используются для инициализации статических переменных. Эти блоки выполняются сразу после объявления статических переменных.

**_Пример:_**

```java
public class Saturn { 
  public static final int MOON_COUNT; 
 
  static { 
    MOON_COUNT = 62; 
  } 
 } 
```

```java
public class Main { 
  public static void main(String[] args) { 
    System.out.println(Saturn.MOON_COUNT); 
  } 
 } 
 // Outputs "62" 
```

Вывод равен 62, потому что переменной `MOON_COUNT` присваивается это значение в статическом блоке.

## Статические вложенные классы

Класс может иметь статический вложенный класс, к которому можно получить доступ, используя внешнее имя класса.

**_Пример:_**

```java
public class Outer { 
 
  public Outer() { 
  } 
 
  public static class Inner { 
    public Inner() { 
    } 
  } 
 } 
```

В приведенном выше примере класс `Inner` может быть напрямую доступен как статический член класса `Outer` .

```java
public class Main { 
  public static void main(String[] args) { 
    Outer.Inner inner = new Outer.Inner(); 
  } 
 } 
```

Один из вариантов использования статических вложенных классов в [шаблоне Builder,](https://en.wikipedia.org/wiki/Builder_pattern#Java) широко используемом в java.