---
title: Strings
localeTitle: Строки
---
# Строки

Строки - это последовательности символов. В Java `String` наследует класс `Object` . Строки не следует путать с типом данных `char` так как `char` это лишь один символ, а не последовательность символов. Вы все равно можете использовать String для хранения одного символа, однако в таком случае предпочтительнее использовать `char`.

```java
String course = "FCC"; 
 System.out.println(course instanceof Object); 
```

Вывод:
```
true 
```

Вы можете создать объект String следующими способами:

1.  `String str = "Это строка"; //как значение строки`
2.  `String str = "Это " + "строка"; //как выражение константа`
3.  `String str = new String("Это строка"); //как объект класса String используя конструктор`

Возможно, вы думаете: в чем разница между этими тремя?

Используя ключевое слово `new` гарантирует, что будет создан новый объект `String`, и новая ячейка памяти будет выделена в `Heap` памяти [(нажмите здесь, чтобы узнать больше)](https://docs.oracle.com/cd/E13150_01/jrockit_jvm/jrockit/geninfo/diagnos/garbage_collect.html). Cтроковые литералы и постоянные выражения `String` кэшируются во время компиляции. Компилятор помещает их в пул строк `String` для предотвращения дублирования и улучшения потребления памяти. Распределение памяти для объектов дорогое, и этот прием увеличивает производительность при создании строк. Если вы используете те же самые значения строк, JVM использует тот же объект. Использование такого конструктора, как и выше, почти всегда является худшим выбором.

В этом фрагменте кода сколько объектов String создано?

```java
String str = "Это строка"; 
 String str2 = "Это строка"; 
 String str3 = new String("Это строка"); 
```

Ответ: 2 Создаются объекты String. `str` и `str2` оба относятся к одному и тому же объекту. `str3` имеет то же самое значение, но с использованием ключевого слова`new` произойдет принудительное создание нового, отличного объекта.

Когда вы создаете строковый литерал, JVM внутренне проверяет пул строк, так называемый `String pool` , чтобы увидеть, может ли он найти аналогичный (по значению) строковый объект. Если он найдет его, он вернет ту же ссылку. В противном случае он просто продолжит работу и создаст новый объект String в пуле, чтобы такая же проверка могла быть выполнена в будущем.

Вы можете проверить это, используя быстрое сравнение объектов `==` и реализованное `equals()` .

```java
System.out.println(str == str2); // Выведет 'true' 
 System.out.println(str == str3); // Выведет 'false' 
 System.out.println(str.equals(str3)); // Выведет 'true' 
```

Вот еще один пример того, как создать строку в Java с помощью разных методов:

```java
public class StringExample{ 
 
   public static void main(String args[]) { 
      String s1 = "java";  // создание строки присвоением строкового значения
      char ch[] = {'s','t','r','i','n','g','s'}; 
      String s2 = new String(ch);  // конвертация массива символов в строку
      String s3 = new String("example");  // создание нового объекта строки используя слово new 
      System.out.println(s1); 
      System.out.println(s2); 
      System.out.println(s3); 
   } 
 } 
```

#### Сравнение строк

Если вы хотите сравнить значение двух переменных String, вы не можете использовать ==. Это связано с тем, что это будет сравнивать _ссылки_ переменных а не значения, которые связаны с ними. Чтобы сравнить значения строк, вы используете метод equals().

```java
boolean equals(Object obj) 
```

Он возвращает true, если два объекта равны и false в противном случае.

```java
String str = "Hello world"; 
 String str2 = "Hello world"; 
 
 System.out.println(str == str2); // Выведет false 
 System.out.println(str.equals(str2); // Выведет true 
```

Первое сравнение ложно, потому что «==» рассматривает ссылки, и они не совпадают.

Второе сравнение верно, потому что переменные хранят одни и те же значения. В этом случае «Hello world».

У нас есть несколько встроенных методов в String. Ниже приведен пример метода String.length(), который вычисляет длину строки в символах.

```java
public class StringDemo { 
 
   public static void main(String args[]) { 
      String palindrome = "Dot saw I was Tod"; 
      int len = palindrome.length(); 
      System.out.println( "String Length is : " + len ); 
   } 
 } 
```

Это приведет к: - `String Length is : 17`

**Ответ: 2** 

Создаются объекты String. 

**Заметки**

1.  В методах String используются индексы с нулевым значением, за исключением второго аргумента `substring()` .
2.  Класс String является окончательным - его методы нельзя переопределить.
3.  Когда литерал String найден JVM, он добавляется в пул строковых литералов.
4.  Класс String имеет имя метода `length()` , а массивы имеют длину имени атрибута.
5.  В java строковые объекты неизменяемы. Неизменяемый просто означает что созданную строку нельзя изменить. После создания строкового объекта его данные или состояние не могут быть изменены, но создается новый строковый объект.

Длина строки

«Длина» строки - это просто количество символов в ней. Итак, «hi» - длина 2, а «Hello» - длина 5. Метод length () в строке возвращает свою длину, например:

```java
String a = "Hello"; 
 int len = a.length();  // длина равна 5 
```

#### Другие методы сравнения, которые также могут использоваться в String:

1.  equalsIgnoreCase(): - сравнивает строку без учета чувствительности к регистру.

```java
String a = "HELLO"; 
 String b = "hello"; 
 System.out.println(a.equalsIgnoreCase(b));   // It will print true 
```

2.  compareTo(): - сравнивает значение лексикографически и возвращает целое число.

```java
String a = "Sam"; 
 String b = "Sam"; 
 String c = "Ram"; 
 System.out.println(a.compareTo(b));       // 0 
 System.out.prinltn(a.compareTo(c));       // 1 потому что (a > b) 
 System.out.println(c.compareTo(a));       // -1 потому что (c < a) 

```
