---
title: Java Virtual Machine
localeTitle: Виртуальная машина Java
---
# Виртуальная машина Java (JVM)

Java принадлежит к семейству языков, называемых [**Compiled Languages**](https://en.wikipedia.org/wiki/Compiled_language) . Любой код, написанный на таком языке, должен быть преобразован (скомпилирован) в промежуточную форму, которая затем может быть понята платформой хоста (ОС / платформа, на которой выполняется код).

Для Java эта промежуточная форма называется **Bytecode,** которая затем интерпретируется средой выполнения, называемой виртуальной машиной Java (JVM). Подумайте о [**JVM**](https://docs.oracle.com/javase/specs/jvms/se7/html/) как о программном обеспечении, которое усложняет работу вашего Java-кода. Он заботится о распределении памяти, управлении потоками, сборке мусора и многом другом. Помимо Java, он также поддерживает (читает: может работать) код, написанный на таких языках, как Groovy, Scala и т. Д.

В Java код записывается и сохраняется как `.java` файлы. Компилятор (javac) работает с java-файлами и генерирует эквивалентные `.class` Bytecode ( `.class` ). Теперь команда `java` сможет выполнить Bytecode, сохраненный в файлах `.class` . Подробнее об этом позже.

В следующих разделах описываются некоторые основные строительные блоки кодирования на Java.