---
title: Variables
localeTitle: Переменные
---
# Переменные


Переменные хранят в себе значения. Они являются самой основной сущностью, используемой для хранения данных, таких как текст, цифры и т.д. в программе.

В [Java](https://github.com/FreeCodeCamp/FreeCodeCamp/wiki/Java) переменные [_строго типизированы_](https://en.wikipedia.org/wiki/Strong_and_weak_typing#Definitions_of_.22strong.22_or_.22weak.22) , что означает, что вы должны определять тип для каждой переменной всякий раз, когда вы ее объявляете. В противном случае компилятор будет выдывать ошибку во [время компиляции](https://en.wikipedia.org/wiki/Compile_time) . Поэтому каждая переменная имеет связанный « [тип данных](https://guide.freecodecamp.org/java/data-types) » одного из следующих:


*   Примитивный тип: `int` , `short` , `char` , `long` , `boolean` , `byte` , `float` , `double`
*   Тип обертки: `Integer` , `Short` , `Char` , `Long` , `Boolean` , `Byte` , `Float` , `Double`
*   Тип ссылки: `String` , `StringBuilder` , `Calendar` , `ArrayList` и т.д.

Возможно Вы могли заметить, что **Оберточный Тип** состоит из типов, записанных точно так же, как и **Примитивный Тип** , за исключением заглавных букв в начале (например, **Ссылочный тип** ). Это связано с тем, что Обёрточные типы фактически являются частью более общих Ссылочных типов, но _тесно связаны_ с их примитивными аналогами посредством [автобоксинга и распаковки](https://docs.oracle.com/javase/tutorial/java/data/autoboxing.html). На данный момент вам просто нужно знать, что такой «Оберточный тип» существует.

Как правило, вы можете _объявлять_ (т.е. cоздавать) переменные в соответствии с следующим синтаксисом: < _data-type_ > < _variableName_ >;

```java
// Примитивный тип данных 
 int i; 
 
 // Ссылочный тип данных 
 Float myFloat; 
```

Вы можете _присвоить_ значение переменной либо единовременно, когда вы объявляете ее (что называется _инициализацией_ ), либо где-либо в коде после того, как вы ее объявили. Символ **\=** используется для одного и того же действия.

```java
//Инициализация переменной примитивного типа 'int' для хранения в ней значения равного 10
 int i = 10; 
 double amount = 10.0; 
 boolean isOpen = false; 
 char c = 'a'; // Обратите внимание на одиночные кавычки
 
 //Также, переменные могут быть инициализированы в одном выражении, а значения присвоены позже
 int j; 
 j = 10; 
 
 //Инициализирует Float объект со значением равным 1.0 
 //переменная Float теперь указывает на объект  
 Float myFloat = new Float(1.0); 
 
 //Байты являются одними из типов данных в Java и могут быть 
 //представлены нижеследующим кодом 
 int byteValue = 0B101; 
 byte anotherByte = (byte)0b00100001; 
```

Как видно из приведенного выше примера, переменные типа Primitive ведут себя несколько иначе, чем переменные типа Reference (& Wrapper), тогда как примитивные переменные _сохраняют_ фактическое значение, ссылочные переменные _относятся к_ «объекту», содержащему фактическое значение. Вы можете узнать больше в разделах, приведенных ниже.

# Другие источники

*   [Типы данных](https://guide.freecodecamp.org/java/data-types)
*   [Классы и объекты](https://guide.freecodecamp.org/java/classes-and-objects)
