---
title: Angularjs Interview Questions
localeTitle: Вопросы интервью Angularjs
---
# Вопросы интервью Angularjs

Вот список понятий, которые часто задают в интервью Angularjs.

*   Что такое AngularJS?
*   Что такое Модель-Представление-Контроллер (MVC)?
*   Двусторонняя привязка данных
*   Что такое инъекция зависимости и как она работает?
*   Что такое $scope в AngularJS?
*   Что такое $rootScope в AngularJS?
*   Как реализовать роутинг в AngularJS?
*   Объясните, что такое директивы
*   Как мы можем создать собственную директиву в Angular?
*   Объясните разницу между service и factory
*   Объясните как работает сервис $q, deferred и promises

# Примеры вопросов и ответов

Вопрос: Перечислите Директивы в AngularJS? Ответ: ngBind, ngModel, ngClass, ngApp, ngInit, ngRepeat

Вопрос: Что такое $scope в AngularJS? Ответ: $scope в AngularJS - это объект, который относится к модели приложения. Это объект, который связывает представление (элемент DOM) с контроллером. В контроллере доступ к данным модели осуществляется через объект $scope. Как известно, AngularJS поддерживает шаблон MV \*, объект $scope становится моделью MV \*.

Вопрос: Что такое SPA (одностраничное приложение) в AngularJS? Ответ. Одностраничные приложения (SPA) - это веб-приложения, которые загружают одну страницу HTML и динамически обновляют эту страницу, когда пользователь взаимодействует с приложением. SPA используют AJAX и HTML для создания гибких веб-приложений без постоянной перезагрузки страницы. Однако это означает, что большая часть работы происходит на стороне клиента, в JavaScript. Одна страница HTML здесь означает страницу ответа UI с сервера. Источником могут быть ASP, ASP.NET, ASP.NET MVC, JSP и т. д. Однако одностраничное веб-приложение поставляется в виде одной страницы в браузере и обычно не требует перезагрузки страницы, поскольку пользователь переходит к различным частям приложения. Это обеспечивает более быструю навигацию, более эффективное использование сетевых ресурсов и лучшую общую производительность для конечного пользователя.

Вопрос: Что такое роутинг в AngularJS? Ответ. Роутинг является основной функцией в AngularJS. Эта функция полезна при создании SPA (Single Page Application) с несколькими представлениями. В приложении SPA все представления - это разные HTML-файлы, и мы используем  роутинг для загрузки различных частей приложения. Это также позволяет разделить приложение логически и сделать его управляемым. Другими словами, роутинг помогает нам разделить наше приложение на логические представления и связать их с разными контроллерами.

Вопрос: Объясните, как работает директива ng-repeat. Ответ. Директива ng-repeat является одной из наиболее часто используемых и полезных в AngularJs. Она выполняет итерацию по набору элементов и создает элементы DOM. Она постоянно контролирует модель для перерисовки шаблона в ответ на изменение данных.

Вопрос: В чем разница между ng-If и ng-show / ng-hide. Ответ: директива ng-If добавляет или удаляет элемент в DOM в зависимости от условия. В то время как дирекривы ng-show / ng-hide скрывают или показывают элемент DOM при помощи классов ng-hide / ng-show.

Вопрос: Как отменить тайм-аут с помощью AngularJS? Ответ: $timeout - обертка AngularJS для window.setTimeout, вы отменяете тайм-аут, применяя функцию:
```
$timeout.cancel(function (){ 
  // write your code. 
 }); 
```

Вопрос: Что такое инъекция зависимостей? Ответ: Dependency Injection (DI) - это шаблон разработки программного обеспечения, который касается того, как компоненты получают свои зависимости. Подсистема инжектора AngularJS отвечает за создание компонентов, разрешение их зависимостей и предоставление их другим компонентам по запросу.

Вопрос: Объясните директиву ng-App. Ответ. Директива ng-app запускает приложение AngularJS. Он определяет корневой элемент. Он автоматически инициализирует или загружает приложение, когда загружается веб-страница, содержащая приложение AngularJS. Он также используется для загрузки модулей AngularJS в приложении.

Вопрос: Объясните директиву ng-init Ответ. Директива ng-init инициализирует данные приложения AngularJS. Он используется, чтобы поместить значения в переменные, которые будут использоваться в приложении. Например: В приведенном ниже примере мы инициализировали массив стран, используя синтаксис JSON.

```html

<div ng-app = "" ng-init = "countries = [{locale:'en-US',name:'United States'}, {locale:'en-GB',name:'United Kingdom'}, {locale:'en-FR',name:'France'}]"> 
   ... 
 </div> 
```

Вопрос: Как реализовать обмен данными между контроллерами? Ответ. Создайть сервис AngularJS, который будет хранить данные и предоставлять их контроллерам. Использование сервиса - самый чистый, быстрый и наиболее удобный для тестирования способ. Однако есть несколько других вариантов реализации обмена данными между контроллерами, например: - Использование событий - Использование $parent, nextSibling, controllerAs и т. д. Для прямого доступа к контроллерам - Использование $rootScope для добавления данных (не очень хорошая практика)

Вопрос: В чем разница между директивами ng-if и ng-show / hide? Ответ: ng-if будет создавать и отображать элемент DOM, когда его условие истинно, если условие ложно или изменяется на false, оно не создаст или уничтожит созданный. ng-show / hide всегда будут создавать элемент DOM, но применят к нему CSS свойства, чтобы скрыть или отобразить этот элемент.

#### Дополнительная информация:

Здесь вы можете найти другие вопросы и ответы:

*   [Вопросы к интервью по AngularJS](https://www.tutorialspoint.com/angularjs/angularjs_interview_questions.htm)
*   [10 вопросов и ответов на интервью по AngularJS](https://www.upwork.com/i/interview-questions/angularjs/)
*   [50 самых важных вопросов для интервью по AngularJS для 100% успеха](http://www.techbeamers.com/latest-angularjs-interview-questions-answers/)
