---
title: Arguments
localeTitle: аргументы
---
Объект arguments - это **объект, подобный массиву** _(в том, что структура объекта аналогична структуре массива, однако он не должен рассматриваться как массив, поскольку он обладает всеми функциональными возможностями объекта)_ , вкотором хранятся все аргументы, которые вы передается функции и, в частности, принадлежит этой функции. Если вы должны были передать 3 аргумента функции, скажем, `storeNames()` , эти 3 аргумента будут храниться внутри объекта с **аргументами,** и это будет выглядеть так, когда мы передадим аргументы `storeNames("Mulder", "Scully", "Alex Krycek")` к нашей функции:

*   Сначала мы объявляем функцию и возвращаем объект arguments.

```Javascript  
function storeNames () {return arguments; }
```

*Затем, когда мы выполним функцию с **n количеством аргументов***, в нашем случае 3 аргумента, нам вернтся объект, который будет ***выглядеть как массив***. Мы можем превратить его в массив, но об этом позже...

```Javascript 
// Если мы выполним следующую строку в консоли: 
storeNames ('Малдер', 'Скалли', 'Алекс Крайчек'); 
// Вывод будет {'0': 'Малдер', '1': 'Скалли', '2': 'Alex Kryceck'}
```

Если вы хотите узнать больше, например, о превращении в массив или о проблеме оптимизации при использовании метода _slice_(_) и о том, как её решить, кликайте **read more** (Только для Gitter Chat).
If you want to know more about this, such as converting it to an array or the optimization problem that comes with using the _slice(_) method and how to solve it, click on **read more** (Gitter Chat Only). 
 
 ## Относитесь к arguments, как к массиву
 
 Вы можете вызвать arguments с помощью `arguments[n]` (где  _n_ это индекс аргумента в объекте подобном массиву), но если вы хотите использовать его, как массив для применения циклов или методов массивов к нему, нужно _превратить его в массив_ объявив переменную и используя метод Array.prototype.slice.call (потому, что _arguments_ это не массив):
 
```javascript
var args = Array.prototype.slice.call(arguments);

// или способ es6: 
var args = Array.from(arguments)
```
Поскольку **slice()** имеет (параметр **end** необязательный) два параметра, вы можете захватить определенную часть arguments уточнив (при сипользовании метода _slice.call()_ оба этих параметра необязательны, не только _end_) начало и окончание нужной части; обратите внимание на следующий код:

```javascript
function getGrades() {
  var args = Array.prototype.slice.call(arguments, 1, 3);
  return args;
}

// Теперь выведем это!
console.log(getGrades(90, 100, 75, 40, 89, 95));

// ВЫВОД ДОЛЖЕН БЫТЬ ТАКИМ: //
// [100, 75] <- Почему? Потому, что он начинался с индекса 1 и останавливался при индексе 3
// поэтому индекс 3 (40) не был учтен.
//
// Если мы удалим параметр «3», оставив только (arguments, 1), мы получим 
// каждый аргумент из индекса 1: \[100, 75, 40, 89, 95\].
```

### Проблемы Оптимизации с Array.slice()

Есть маленькая проблема, не рекомендуется использовать _slice_ в объекте arguments (по причинам оптимизации)...

> **Важно**: Не следует использовать _slice_ с arguments потому, что не сработает оптимозация в движках JavaScript (напр. V8).
Вместо этого попробуйте создвть новый массив запустив цикл через объект arguments.
>
 > _согласно_ **_Mozilla Developer Network_** <a href='https://developer.mozilla.org/ca/docs/Web/JavaScript/Reference/Functions/arguments' target='_blank' rel='nofollow'>(reference)<a> 

 
 
Итак, какие еще методы доступны для превращения _arguments_ в массив? Я рекомендую цикл for (не for-in), можете сделать так:

```javascript
var args = []; // Пустой массив, сперва.
for (var i = 0; i <arguments.length; i ++) { 
  args.push(arguments[i]) 
} // Теперь «args» - это массив, содержащий ваши аргументы. 
 ```

Для получения дополнительной информации по вопросам оптимизации:  
Убийцы оптимизации: [управляющие аргументы](https://github.com/petkaantonov/bluebird/wiki/Optimization-killers#3-managing-arguments)

### Параметр остатка ES6 как способ обхода объекта аргументов

В ES2015 / ES6 можно использовать параметр rest ( `...` ) вместо объекта arguments в большинстве мест. Скажем, у нас есть следующая функция (не-ES6):

```javascript
function getIntoAnArgument() { 
  var args = arguments.slice(); 
  args.forEach(function(arg) { 
    console.log(arg); 
  }); 
} 
```

Эту функцию можно заменить в ES6:

```
function getIntoAnArgument(...args) { 
  args.forEach(arg => console.log(arg)); 
} 
```

Обратите внимание, что мы также использовали стрелочную функцию для сокращения обратного вызова forEach!

Объект arguments недоступен внутри тела стрелочной функции.

Параметр rest всегда должен быть последним аргументом в определении вашей функции.  
```
function getIntoAnArgument(arg1, arg2, arg3, ...restOfArgs /*no more arguments allowed here*/) {
  //function body 
}
```
