---
title: Arrow Functions
localeTitle: Стрелочные функции
---


Стрелочные функции - новый синтаксис ES6 для написания выражений функций JavaScript. Более короткий синтаксис экономит время, а также упрощает область действия.

## Что такое стрелочная функция?


Стрелочные функции — более краткий синтаксис для написания функций с использованием стрелки ( `=>` ).


### Основной синтаксис

Ниже приведен базовый пример стрелочной функции:

```javascript
// синтаксис в ES5 
 var multiply = function(x, y) { 
  return x * y; 
 }; 
 
 // стрелочные функции в ES6 
 var multiply = (x, y) => { return x * y; }; 
 
 // или еще проще
 var multiply = (x, y) => x * y; 
```



Вам больше не нужны `function` и `return`, или даже фигурные скобки.

### Упрощение `this`

Стрелочные функции, новые функции, определяют собственное `this` значение. Чтобы использовать `this` в традиционном выражении функции, мы должны написать обходное решение так:



```javascript
// синтаксис ES5 
 function Person() { 
  // мы привязываем `this` к переменной `self`, которую можно использовать позже
  var self = this; 
  self.age = 0; 
 
  setInterval(function growUp() { 
    // `self` ссылается на нужный нам объект 
    self.age++; 
  }, 1000); 
 } 
```


Стрелочная функция не определяет своего собственного значения `this`, а наследует `this` от родительской функции:



```javascript
// синтаксис ES6 
 function Person(){ 
  this.age = 0; 
 
  setInterval(() => { 
    // `this` теперь ссылается на объект Person, отлично! 
    this.age++; 
  }, 1000); 
 } 
 
 var p = new Person(); 
```

#### Дополнительные материалы


[Ссылка MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Arrow_functions)