---
title: Assignment Operators
localeTitle: Операторы присваивания
---
# Операторы присваивания

Операторы присваивания, как следует из названия, присваивают (или повторно назначают) значения переменной. Хотя на операторах присваивания довольно много вариаций, все они строятся из основного оператора присваивания.

## Синтаксис

|`x = y;` | Описание | Необходимость|
|:---------:|:----------:|:--------------:|
|`x` | Переменная | необходимые|
|`=` | Оператор присваивания | необходимые|
|`y` | Значение для назначения переменной | необходимые|

## Примеры
```
let initialVar = 5;   // Variable initialization requires the use of an assignment operator 
 
 let newVar = 5; 
 newVar = 6;   // Variable values can be modified using an assignment operator 
```

## вариации

Другие операторы присваивания являются сокращением для выполнения некоторой операции с использованием переменной (обозначенной выше x) и значением (указано выше y), а затем присваиванием результата самой переменной.

Например, ниже приведен синтаксис для оператора присваивания:
```
x += y; 
```

Это то же самое, что и применение оператора сложения и переназначение суммы в исходную переменную (т. Е. X), которая может быть выражена следующим кодом:
```
x = x + y; 
```

Чтобы проиллюстрировать это с использованием фактических значений, вот еще один пример использования оператора присваивания:
```
let myVar = 5;   // value of myVar: 5 
 myVar += 7;   // value of myVar: 12 = 5 + 7 
```

## Полный список операторов присваивания Javascript

Оператор | Синтаксис | Длинная версия  
|------------------------------- | --------- | -------------  
Назначение | x = y | x = y  
Назначение добавления | x + = y | x = x + y  
Вычисление вычитания | x - = y | x = x - y  
Назначение умножения | x \* = y | x = x \* y  
Подразделение | x / = y | x = x / y  
Назначение останков | x% = y | x = x% y  
Назначение возведения в степень | x \*\* = y | x = x \*\* y  
Назначение левого сдвига | x << = y | x = x << y 
Назначение правого сдвига | x >> = y | x = x >> y  
Беззнаковое присваивание сдвига вправо | x >>> = y | x = x >>> y  
Побитовое И назначение | x & = y | x = x & y  
Побитовое назначение XOR | x ^ = y | x = x ^ y  
Побитовое назначение OR | x | = y | x = x | Y

### Дополнительная информация:

[Ссылка MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Assignment_Operators#Assignment)

[Ссылка MSDN](https://docs.microsoft.com/en-us/scripting/javascript/reference/assignment-operator-decrement-equal-javascript)
