---
title: Boolean
localeTitle: Булев (логический) тип
---
## Булев (логический) тип

Логический тип - это примитивный тип данных, обычно используемый в компьютерных языках программирования. По определению логический тип имеет два возможных значения: `true` или `false` .

В Javascript часто подразумевается приведение типа к логическому. Если, например, у вас есть оператор if, который проверяет определенное выражение, это выражение будет приведено к логическому типу:

```javascript
var a = 'a string'; 
 if (a) { 
  console.log(a); // logs 'a string' 
 } 
```

Есть только несколько значений, которые будут приведены к false:

*   false (на самом деле не будет приведено, поскольку оно уже false)
*   null
*   undefined
*   NaN
*   0
*   '' или "" (пустая строка)

Все остальные значения будут приведены к true. Когда значение приводится к логическому, мы также называем его «ложным» или «правдивым».

Одним из способов приведения к этому типу является использование операторов или ( `||` ) и ( `&&` ):

```javascript
var a = 'word'; 
 var b = false; 
 var c = true; 
 var d = 0 
 var e = 1 
 var f = 2 
 var g = null 
 
 console.log(a || b); // 'word' 
 console.log(c || a); // true 
 console.log(b || a); // 'word' 
 console.log(e || f); // 1 
 console.log(f || e); // 2 
 console.log(d || g); // null 
 console.log(g || d); // 0 
 console.log(a && c); // true 
 console.log(c && a); // 'word' 
```

Как вы можете видеть, оператор _or_ проверяет первый операнд. Если его значение приводится к true, он немедленно возвращает его (именно поэтому мы получаем слово в первом случае и true во втором случае). Если его значение приводится к false, он возвращает второй операнд (именно поэтому мы получаем «слово» в третьем случае).

С оператором _and_ он работает аналогичным образом, но для _and_, чтобы быть правдой, оба операнда должны быть правдивыми. Поэтому он всегда будет возвращать второй операнд, если оба они истинны / правдивы, иначе он вернет false. Вот почему в четвертом случае мы получаем истину, а в последнем случае получаем слово.

## Булев объект

Существует также встроенный JavaScript-объект, который оборачивает значение. Значение, переданное как первый параметр, при необходимости преобразуется в булево значение. Если значение опущено, 0, -0, null, false, NaN, undefined или пустая строка (""), объект имеет начальное значение false. Все остальные значения, включая любой объект или строку «false», создают объект с начальным значением true.

Не путайте примитивные логические значения true и false с истинными и ложными значениями объекта Boolean.

## Подробнее

Любой объект, значение которого не является неопределенным или null, включая логический объект, значение которого является ложным, оценивается как true при передаче в условный оператор. Если true, это приведет к выполнению функции. Например, условие в следующем выражении if равно true:

```javascript
var x = new Boolean(false); 
 if (x) { 
  // this code is executed 
 } 
```

Это поведение не относится к булевым примитивам. Например, условие в следующем выражении if равно false:

```javascript
var x = false; 
 if (x) { 
  // this code is not executed 
 } 
```

Не используйте объект Boolean для преобразования небулевого значения в логическое значение. Вместо этого используйте Boolean как функцию для выполнения этой задачи:

```javascript
var x = Boolean(expression);     // preferred 
 var x = new Boolean(expression); // don't use 
```

Если вы укажете любой объект, включая логический объект, значение которого является ложным, в качестве начального значения булева объекта, новый объект Boolean имеет значение true.

```javascript
var myFalse = new Boolean(false);   // initial value of false 
 var g = new Boolean(myFalse);       // initial value of true 
 var myString = new String('Hello'); // string object 
 var s = new Boolean(myString);      // initial value of true 
```

Не используйте Boolean-объект вместо булевского примитива.

### Ресурсы

*   [Логический объект](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)
*   [Логический объект](https://docs.oracle.com/javase/7/docs/api/java/lang/Boolean.html)
