---
title: Comparison Operators
localeTitle: Операторы сравнения
---
JavaScript имеет как **строгие, так** и **типовые преобразования** .

*   Строгое сравнение (например, ===) справедливо только в том случае, если операнды одного типа.
    
*   Более часто используемое абстрактное сравнение (например, ==) преобразует операнды в один и тот же тип перед проведением сравнения.
    
*   Для реляционных абстрактных сравнений (например, <=) операнды сначала преобразуются в примитивы, а затем к тому же типу перед сравнением.
    
*   Строки сравниваются на основе стандартного лексикографического упорядочения, используя значения Unicode.
    

## Особенности сравнения:

*   Две строки строго равны, если они имеют одну и ту же последовательность символов, одну и ту же длину и одинаковые символы в соответствующих позициях.
    
*   Два числа строго равны, если они численно равны (имеют одинаковое числовое значение). NaN не равно никому, включая NaN. Положительные и отрицательные нули равны друг другу.
    
*   Два булевых операнда строго равны, если оба они истинны или оба ложны.
    
*   Два разных объекта никогда не равны ни для строгих, ни для абстрактных сравнений.
    
*   Выражение, сравнивающее объекты, истинно, только если операнды ссылаются на один и тот же объект.
    
*   Null и Undefined Types строго равны себе и абстрактно равны друг другу.
    

## Операторы равенства

### Равенство (==)

Оператор равенства преобразует операнды, если они **не одного типа** , а затем применяет строгое сравнение. Если **оба операнда являются объектами** , тогда JavaScript сравнивает внутренние ссылки, равные, когда операнды относятся к одному и тому же объекту в памяти.

#### Синтаксис
```
 x == y 
```

#### Примеры
```
 1   ==  1        // true 
 "1"  ==  1        // true 
 1   == '1'       // true 
 0   == false     // true 
 0   == null      // false 
 
   0   == undefined   // false 
 null  == undefined   // true 
```

### Неравенство (! =)

Оператор неравенства возвращает true, если операнды не равны. Если два операнда **не одного типа** , JavaScript пытается преобразовать операнды в соответствующий тип для сравнения. Если **оба операнда являются объектами** , тогда JavaScript сравнивает внутренние ссылки, которые не равны, когда операнды относятся к различным объектам в памяти.

#### Синтаксис
```
x != y 
```

#### Примеры
```
1 !=   2     // true 
 1 !=  "1"    // false 
 1 !=  '1'    // false 
 1 !=  true   // false 
 0 !=  false  // false 
```

### Идентичность / строгое равенство (===)

Оператор identity возвращает true, если операнды строго равны **без преобразования типа** .

#### Синтаксис
```
x === y 
```

#### Примеры
```
3 === 3   // true 
 3 === '3' // false 
```

### Нетождественное / строгое неравенство (! ==)

Оператор, не являющийся идентификатором, возвращает true, если операнды **не равны и / или не того же типа** .

#### Синтаксис
```
x !== y 
```

#### Примеры
```
3 !== '3' // true 
 4 !== 3   // true 
```

## Операторы отношения

### Больше, чем оператор (>)

Оператор больше, чем оператор, возвращает true, если левый операнд больше, чем правый операнд.

#### Синтаксис
```
x > y 
```

#### Примеры
```
4 > 3 // true 
```

### Оператор больше или равно (> =)

Оператор большего или равного возвращает true, если левый операнд больше или равен правильному операнду.

#### Синтаксис
```
x >= y 
```

#### Примеры
```
4 >= 3 // true 
 3 >= 3 // true 
```

### Меньше оператора (<)

Оператор меньше, чем оператор, возвращает true, если левый операнд меньше, чем правый операнд.

#### Синтаксис
```
x < y 
```

#### Примеры
```
3 < 4 // true 
```

### Меньший или равный оператор (<=)

Оператор меньше или равно возвращает true, если левый операнд меньше или равен правильному операнду.

#### Синтаксис
```
x <= y 
```

#### Примеры
```
3 <= 4 // true 
```

_Дополнительную информацию вы можете найти в [MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Comparison_Operators) ._

## Сравнение нулевых и неопределенных

Когда мы сравниваем null и undefined, мы видим другое поведение. Позволяет проверять различные сценарии с помощью примеров

#### Пример - строгая проверка равенства (===)

console.log (null === undefined); // O / P - false

Otuput является ложным, и это правильно, потому что мы знаем, что «null» и «undefined» - разные типы.

#### Пример - проверка не строгого равенства (==)

console.log (null == undefined); // O / P: - true

Как? Это связано с тем, что существует специальное правило для «null» и «undefined». В связи с этим они равны в случае нестрогой проверки (==), но не равны никакому другому значению.

Если мы используем операторы сравнения, такие как <,>, <=,> = и т. Д., «Null» и «undefined» преобразуются в число, и в таких случаях «null» станет 0, а «undefined» будет NaN. Давайте рассмотрим некоторые из этих примеров.

#### Пример - сравните значение null с 0 (ноль)

console.log (null> 0); // O / P - false console.log (null> = 0); // O / P - true console.log (null == 0); // O / P - false

Странный? В соответствии с первым утверждением null не больше 0, а из второго оператора null является либо большим, либо равным 0. Таким образом, если мы математически мыслим и сравниваем оба утверждения, то получится, что значение null равно 0. Но , согласно третьему утверждению это неверно. Зачем?

Причина в том, что «сравнение» и «проверка равенства» работают по-разному. Для сравнения, «null / undefined» сначала преобразуется в число, поэтому в первых двух случаях «null» становится 0 и, следовательно, case1) (null> 0) -> false и case2) (null> = 0) -> true. Но при проверке равенства (==) «null / undefined» работает без какого-либо преобразования и, как объяснялось выше (специальное правило), проверка равенства «null / undefined» равна только друг другу и не равна никому другому. Следовательно (null == 0) -> false.

#### Пример - сравнение undefined с 0 (ноль)

console.log (undefined> 0); // O / P - false console.log (undefined> = 0); // O / P - false console.log (undefined == 0); // O / P - false

Здесь мы тестируем те же случаи, что и мы, для null, но результат опять же отличается. Зачем?

Причины следующие. В первых двух случаях мы сравниваем undefined с 0 и, как упоминалось выше, в сравнении undefined преобразуется в NaN. NaN - особое значение, которое всегда возвращает false по сравнению с любым числом, и поэтому мы получили false как результат в первых двух случаях. Для третьего утверждения причина та же, что и для «null». В проверке равенства «null / undefined» равны только друг другу и не равны ни одному другому. Следовательно (undefined == 0) -> false.