---
title: Converting Strings to Numbers
localeTitle: Преобразование строк в числа
---
## Преобразование строк в числа

Функция `parseInt()` анализирует строковый аргумент и возвращает целое число указанного основани (основание в математических числовых системах).

```js
    parseInt(string, radix); 
```

### параметры
```
string 
```

Значение для синтаксического анализа. Если `string` аргумент не является строкой, он преобразуется в строку (используя абстрактную операцию `ToString` ). Ведущие пробелы в строковом аргументе игнорируются. '= основание системы счисления Целое число от 2 до 36, которое представляет собой основание (основание в математических числовых системах) вышеупомянутой строки. Укажите `10` для десятичной цифровой системы, обычно используемой людьми. Всегда указывайте этот параметр, чтобы устранить недоразумение читателя и гарантировать предсказуемое поведение. Различные реализации приводят к разным результатам, когда редикс не указан, обычно по умолчанию значение равно 10. Возвращаемое значение Целочисленное число обрабатывается из данной строки. Если первый символ не может быть преобразован в число, возвращается `NaN` .

### Описание

Функция `parseInt` преобразует свой первый аргумент в строку, анализирует его и возвращает целое число или `NaN` . Если не `NaN` , возвращаемое значение будет целым числом, которое является первым аргументом, принятым как число в указанном базисе (base). Например, радиус 10 указывает на преобразование из десятичного числа, 8 восьмеричных, 16 шестнадцатеричных и т. Д. Для радиусов выше `10` буквы алфавита указывают цифры больше 9. Например, для шестнадцатеричных чисел (основание 16) используется от `A` до `F`

Если `parseInt` встречает символ, который не является цифрой в указанном радиусе, он игнорирует его и все последующие символы и возвращает целочисленное значение, обработанное до этой точки. `parseInt` усекает числа до целых значений. Допускаются ведущие и конечные пробелы.

Поскольку некоторые числа включают символ `e` в их `6.022e23` представлении (например, `6.022e23` ), использование `parseInt` для усечения числовых значений приведет к неожиданным результатам при использовании на очень больших или очень малых числах. `parseInt` не должен использоваться в качестве замены для `Math.floor()` .

Если radix `undefined` или 0 (или отсутствует), JavaScript предполагает следующее:

*   Если начальная `string` начинается с «0x» или «0X», radix равен 16 (шестнадцатеричный), а оставшаяся часть строки анализируется.
*   Если входная `string` начинается с «0», то радиус равен восьми (восьмеричный) или 10 (десятичный). Именно тот, который выбран радик, зависит от реализации. ECMAScript 5 указывает, что используется 10 (десятичное), но не все браузеры поддерживают это. По этой причине всегда указывайте radix при использовании parseInt.
*   Если начальная `string` начинается с любого другого значения, то радиус равен 10 (десятичный).
*   Если первый символ не может быть преобразован в число, parseInt возвращает NaN.

Для арифметических целей значение NaN не является числом в любом радиусе. Вы можете вызвать функцию isNaN, чтобы определить, является ли результат parseInt NaN. Если NaN передается на арифметические операции, результаты операции также будут NaN.

Чтобы преобразовать число в его строковый литерал в конкретном радиксе, используйте intValue.toString (radix).

### Примеры

Использование `parseInt` Следующие примеры возвращают `15` :

```js
    parseInt(' 0xF', 16); 
    parseInt(' F', 16); 
    parseInt('17', 8); 
    parseInt(021, 8); 
    parseInt('015', 10);   // parseInt(015, 10); will return 15 
    parseInt(15.99, 10); 
    parseInt('15,123', 10); 
    parseInt('FXX123', 16); 
    parseInt('1111', 2); 
    parseInt('15 * 3', 10); 
    parseInt('15e2', 10); 
    parseInt('15px', 10); 
    parseInt('12', 13); 
```

Следующие примеры возвращают `NaN` :

```js
    parseInt('Hello', 8); // Not a number at all 
    parseInt('546', 2);   // Digits are not valid for binary representations 
```

Следующие примеры возвращают `-15` :

```js
    parseInt('-F', 16); 
    parseInt('-0F', 16); 
    parseInt('-0XF', 16); 
    parseInt(-15.1, 10) 
    parseInt(' -17', 8); 
    parseInt(' -15', 10); 
    parseInt('-1111', 2); 
    parseInt('-15e1', 10); 
    parseInt('-12', 13); 
```

Следующие примеры возвращают `4` :

```js
    parseInt(4.7, 10); 
    parseInt(4.7 * 1e22, 10); // Very large number becomes 4 
    parseInt(0.00000000000434, 10); // Very small number becomes 4 
```

Следующий пример возвращает `224` :

```js
    parseInt('0e0', 16); 
```

#### Дополнительная информация:

[parseInt на MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Comparison_Operators)

*   [parseInt ()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseInt) и [parseFloat ()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseFloat) пытаются, если это возможно, преобразовать строку в число. Например, `var x = parseInt("100"); // x = 100`
*   [Number ()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/number) преобразуется в число, которое может быть представлено. Это включает даты в миллисекундах с полуночи 1 января 1970 UTC, логические значения до 1 или 0, а значения, которые не могут быть преобразованы в распознаваемое число, станут NaN. Это означает «Не номер», а также технически число!