---
title: Default Parameters
localeTitle: Параметры по умолчанию
---
## Параметры по умолчанию

Если вы знакомы с другими языками программирования, такими как Ruby, Python, то параметры по умолчанию для вас не новы.

Параметры по умолчанию - это параметры, которые задаются по умолчанию при объявлении функции. Но это значение может быть изменено при вызове функции.

пример
```
let Func = (a, b = 10) => { 
 return a + b; 
 } 
 Func(20); // 20 + 10 = 30 
```

В приведенном выше примере мы передаем только один параметр. Функция использует параметр по умолчанию и выполняет функцию.

Рассмотрим другой пример:
```
Func(20, 50); // 20 + 50 = 70 
```

В приведенном выше примере функция принимает два параметра, а второй параметр заменяет параметр по умолчанию.

Рассмотрим другой пример:
```
let NotWorkingFunction = (a = 10, b) => { 
 return a + b; 
 } 
 NotWorkingFunction(20); // NAN. Not gonna work. 
```

Когда вы вызываете функцию с параметрами, они назначаются в порядке. (т.е.) первое значение присваивается первому параметру, а второе значение присваивается второму параметру и т. д.

В приведенном выше примере значение 20 присваивается параметру «a», а «b» не имеет значения. Таким образом, мы не получаем никакой информации.

Но,
```
NotWorkingFunction(20, 30); // 50; 
```

Работает отлично.