---
title: ES6
localeTitle: ES6
---
## ES6

6-е издание ECMAScript называется ES6.

Он также известен как ES2015.

Изменения добавляют много синтаксического сахара, которые позволяют разработчикам создавать приложения в объектно-ориентированном стиле.

> Пример ES5:

```javascript
var User = function () { 
  function User(name) { 
    this._name = name; 
  } 
 
  User.prototype.getName = function getName(x) { 
    return 'Mr./Mrs. ' + this._name; 
  }; 
 
  return User; 
 }(); 
```

> Пример ES6:

```javascript
class User { 
  constructor(name) { 
    this._name = name 
  } 
 
  getName() { 
    return `Mr./Mrs. ${this._name}` 
  } 
 } 
```

Было введено множество новых синтаксических функций, включая:

*   классы,
*   модули,
*   шаблонный,
*   для / из петель,
*   генераторные выражения,
*   стрелки,
*   коллекции,
*   обещания.

В настоящее время большинство функций доступны во всех популярных браузерах. Таблица [совместимости](https://kangax.github.io/compat-table/es6/) содержит всю информацию о доступности функций всех современных браузеров.

Часто появляются новые функции, которые являются частью преемника ES7. Обычный способ - перевести современный JavaScript (ES6, ES7 и другие экспериментальные предложения) на ES5. Это гарантирует, что и старые браузеры могут выполнять код. Существуют такие инструменты, как [Babel,](https://babeljs.io/) который преобразует новый JavaScript в ES5.

Помимо синтаксического сахара, поступающего из стандартов ECMAScript, существуют функции, требующие [Polyfill](https://babeljs.io/docs/usage/polyfill) . Обычно они необходимы, потому что к стандарту добавлены целые реализации класса / метода.