---
title: Higher Order Functions
localeTitle: Функции более высокого порядка
---
## Функции более высокого порядка

Функция высшего порядка - это любая функция, которая возвращает функцию при выполнении, принимает функцию как один или несколько своих аргументов или и то, и другое. Если вы использовали какой-либо из методов `Array` например `map` или `filter` , или передали функцию обратного вызова в `$.get` jQuery, вы уже работали с функциями более `$.get` порядка.

Когда вы используете `Array.map` , вы предоставляете функцию как единственный аргумент, который применяется к каждому элементу, содержащемуся в массиве.

```javascript
var arr = [ 1, 2, 3 ]; 
 
 var arrDoubled = arr.map(function(num) { 
  return num * 2; 
 }); 
 
 console.log(arrDoubled); // [ 2, 4, 6 ] 
```

Функции более высокого порядка также могут возвращать функцию. Например, вы можете сделать функцию `multiplyBy` которая принимает число и возвращает функцию, которая умножает другое число, которое вы предоставляете первым предоставленным номером. Вы можете использовать этот подход для создания функции `multiplyByTwo` для перехода к `Array.map` . Это даст вам тот же результат, который вы видели выше.

```javascript
function multiplyBy(num1) { 
  return function(num2) { 
    return num1 * num2; 
  } 
 } 
 
 var multiplyByTwo = multiplyBy(2); 
 
 var arr = [ 1, 2, 3 ]; 
 
 var arrDoubled = arr.map(multiplyByTwo); 
 
 console.log(arrDoubled); // [ 2, 4, 6 ] 
```

См. Руководство по [закрытию](https://guide.freecodecamp.org/javascript/closures) для получения дополнительной информации о том, как `multiplyByTwo` сохраняет ссылку на `num1` в приведенном выше примере.

[Дополнительная информация о Closures](https://eloquentjavascript.net/05_higher_order.html)