---
title: For Loop
localeTitle: Для цикла
---
### Синтаксис

```javascript
for ([initialization]); [condition]; [final-expression]) { 
   // statement 
 } 
```

Оператор javascript `for` состоит из трех выражений и оператора:

## Описание

*   Инициализация - Запуск до первого выполнения цикла. Это выражение обычно используется для создания счетчиков. Переменные, созданные здесь, привязаны к циклу. Как только цикл завершит выполнение, они будут уничтожены.
*   condition - выражение, которое проверяется перед выполнением каждой итерации. Если это опущено, это выражение оценивается как true. Если он вычисляет значение true, выполняется оператор цикла. Если он оценивает значение false, цикл останавливается.
*   final-expression - выражение, которое запускается после каждой итерации. Обычно используется для увеличения счетчика. Но он также может использоваться для уменьшения счетчика.
*   statement - Код, который необходимо повторить в цикле

любое из этих трех выражений или утверждение можно опустить. Для циклов обычно используются для подсчета определенного количества итераций для повторения утверждения. Используйте оператор `break` для выхода из цикла, пока выражение условия не примет значение false.

## Общие проблемы

**Превышение границ массива**

При многократном индексировании по массиву легко превзойти границы массива (например, попытайтесь ссылаться на 4-й элемент массива из 3 элементов).

```javascript
    // This will cause an error. 
    // The bounds of the array will be exceeded. 
    var arr = [ 1, 2, 3 ]; 
    for (var i = 0; i <= arr.length; i++) { 
       console.log(arr[i]); 
    } 
 
    output: 
    1 
    2 
    3 
    undefined 
```

Есть два способа исправить этот код. Задайте условие либо `i < arr.length` либо `i <= arr.length - 1`

### Примеры

Итерации через целые числа от 0 до 8

```javascript
for (var i = 0; i < 9; i++) { 
   console.log(i); 
 } 
 
 output: 
 0 
 1 
 2 
 3 
 4 
 5 
 6 
 7 
 8 
```

Вырыв из цикла до выражения условия false

```javascript
for (var elephant = 1; elephant < 10; elephant+=2) { 
    if (elephant === 7) { 
        break; 
    } 
    console.info('elephant is ' + elephant); 
 } 
 
 output: 
 elephant is 1 
 elephant is 3 
 elephant is 5 
```

### Другие источники

*   [MDN - для заявлений](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for)